/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.SoundType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class SoundTypeDeserialiser
implements JsonDeserialiser<SoundType> {
    private static final Map<ResourceLocation, SoundType> SOUND_TYPES = (Map)Util.func_200696_a(new HashMap(), soundTypes -> {
        soundTypes.put(new ResourceLocation("wood"), SoundType.field_185848_a);
        soundTypes.put(new ResourceLocation("gravel"), SoundType.field_185849_b);
        soundTypes.put(new ResourceLocation("grass"), SoundType.field_185850_c);
        soundTypes.put(new ResourceLocation("lily_pad"), SoundType.field_235600_d_);
        soundTypes.put(new ResourceLocation("stone"), SoundType.field_185851_d);
        soundTypes.put(new ResourceLocation("metal"), SoundType.field_185852_e);
        soundTypes.put(new ResourceLocation("glass"), SoundType.field_185853_f);
        soundTypes.put(new ResourceLocation("wool"), SoundType.field_185854_g);
        soundTypes.put(new ResourceLocation("sand"), SoundType.field_185855_h);
        soundTypes.put(new ResourceLocation("snow"), SoundType.field_185856_i);
        soundTypes.put(new ResourceLocation("ladder"), SoundType.field_185857_j);
        soundTypes.put(new ResourceLocation("anvil"), SoundType.field_185858_k);
        soundTypes.put(new ResourceLocation("slime_block"), SoundType.field_185859_l);
        soundTypes.put(new ResourceLocation("honey_block"), SoundType.field_226947_m_);
        soundTypes.put(new ResourceLocation("wet_grass"), SoundType.field_211382_m);
        soundTypes.put(new ResourceLocation("coral_block"), SoundType.field_211383_n);
        soundTypes.put(new ResourceLocation("bamboo"), SoundType.field_222468_o);
        soundTypes.put(new ResourceLocation("bamboo_sapling"), SoundType.field_222469_p);
        soundTypes.put(new ResourceLocation("scaffolding"), SoundType.field_222470_q);
        soundTypes.put(new ResourceLocation("sweet_berry_bush"), SoundType.field_222471_r);
        soundTypes.put(new ResourceLocation("crop"), SoundType.field_222472_s);
        soundTypes.put(new ResourceLocation("hard_crop"), SoundType.field_222473_t);
        soundTypes.put(new ResourceLocation("vine"), SoundType.field_235601_w_);
        soundTypes.put(new ResourceLocation("nether_wart"), SoundType.field_222474_u);
        soundTypes.put(new ResourceLocation("lantern"), SoundType.field_222475_v);
        soundTypes.put(new ResourceLocation("stem"), SoundType.field_235602_z_);
        soundTypes.put(new ResourceLocation("nylium"), SoundType.field_235579_A_);
        soundTypes.put(new ResourceLocation("fungus"), SoundType.field_235580_B_);
        soundTypes.put(new ResourceLocation("roots"), SoundType.field_235581_C_);
        soundTypes.put(new ResourceLocation("shroomlight"), SoundType.field_235582_D_);
        soundTypes.put(new ResourceLocation("weeping_vines"), SoundType.field_235583_E_);
        soundTypes.put(new ResourceLocation("twisting_vines"), SoundType.field_235584_F_);
        soundTypes.put(new ResourceLocation("soul_sand"), SoundType.field_235585_G_);
        soundTypes.put(new ResourceLocation("soul_soil"), SoundType.field_235586_H_);
        soundTypes.put(new ResourceLocation("basalt"), SoundType.field_235587_I_);
        soundTypes.put(new ResourceLocation("wart_block"), SoundType.field_235588_J_);
        soundTypes.put(new ResourceLocation("netherrack"), SoundType.field_235589_K_);
        soundTypes.put(new ResourceLocation("nether_bricks"), SoundType.field_235590_L_);
        soundTypes.put(new ResourceLocation("nether_sprouts"), SoundType.field_235591_M_);
        soundTypes.put(new ResourceLocation("nether_ore"), SoundType.field_235592_N_);
        soundTypes.put(new ResourceLocation("bone_block"), SoundType.field_235593_O_);
        soundTypes.put(new ResourceLocation("netherite_block"), SoundType.field_235594_P_);
        soundTypes.put(new ResourceLocation("ancient_debris"), SoundType.field_235595_Q_);
        soundTypes.put(new ResourceLocation("lodestone"), SoundType.field_235596_R_);
        soundTypes.put(new ResourceLocation("chain"), SoundType.field_235597_S_);
        soundTypes.put(new ResourceLocation("nether_gold_ore"), SoundType.field_235598_T_);
        soundTypes.put(new ResourceLocation("gilded_blackstone"), SoundType.field_235599_U_);
    });

    public static void registerSoundType(ResourceLocation name, SoundType soundType) {
        SOUND_TYPES.putIfAbsent(name, soundType);
    }

    @Override
    public Result<SoundType, JsonElement> deserialise(JsonElement input) {
        return JsonDeserialisers.RESOURCE_LOCATION.deserialise(input).map(SOUND_TYPES::get, "Could not get sound type from \"{}\".");
    }
}

