/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.api.configurations.PropertyDefinition;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;

public final class PropertyDefinitionDeserialiser
implements JsonDeserialiser<PropertyDefinition<?>> {
    @Override
    public Result<PropertyDefinition<?>, JsonElement> deserialise(JsonElement input) {
        return JsonDeserialisers.JSON_OBJECT.deserialise(input).map(this::deserialiseDefinition);
    }

    private <T> PropertyDefinition<T> deserialiseDefinition(JsonObject object, Consumer<String> warningAppender) throws DeserialisationException {
        String key = object.get("key").getAsString();
        Class type = (Class)JsonDeserialisers.DESERIALISABLE_CLASS.deserialise(object.get("type")).forEachWarning(warningAppender).orElseThrow();
        Object defaultValue = JsonDeserialisers.get(type).deserialise(object.get("default")).forEachWarning(warningAppender).orElse(null);
        return new PropertyDefinition<Object>(key, type, defaultValue);
    }
}

