/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class MaterialDeserialiser
implements JsonDeserialiser<Material> {
    private static final Map<ResourceLocation, Material> MATERIALS = (Map)Util.func_200696_a(new HashMap(), materials -> {
        materials.put(new ResourceLocation("air"), Material.field_151579_a);
        materials.put(new ResourceLocation("structural_air"), Material.field_189963_J);
        materials.put(new ResourceLocation("portal"), Material.field_151567_E);
        materials.put(new ResourceLocation("cloth_decoration"), Material.field_151593_r);
        materials.put(new ResourceLocation("plant"), Material.field_151585_k);
        materials.put(new ResourceLocation("water_plant"), Material.field_203243_f);
        materials.put(new ResourceLocation("replaceable_plant"), Material.field_151582_l);
        materials.put(new ResourceLocation("replaceable_fireproof_plant"), Material.field_242934_h);
        materials.put(new ResourceLocation("replaceable_water_plant"), Material.field_204868_h);
        materials.put(new ResourceLocation("water"), Material.field_151586_h);
        materials.put(new ResourceLocation("bubble_column"), Material.field_203244_i);
        materials.put(new ResourceLocation("lava"), Material.field_151587_i);
        materials.put(new ResourceLocation("top_snow"), Material.field_151597_y);
        materials.put(new ResourceLocation("fire"), Material.field_151581_o);
        materials.put(new ResourceLocation("decoration"), Material.field_151594_q);
        materials.put(new ResourceLocation("web"), Material.field_151569_G);
        materials.put(new ResourceLocation("buildable_glass"), Material.field_151591_t);
        materials.put(new ResourceLocation("clay"), Material.field_151571_B);
        materials.put(new ResourceLocation("dirt"), Material.field_151578_c);
        materials.put(new ResourceLocation("grass"), Material.field_151577_b);
        materials.put(new ResourceLocation("ice_solid"), Material.field_151598_x);
        materials.put(new ResourceLocation("sand"), Material.field_151595_p);
        materials.put(new ResourceLocation("sponge"), Material.field_151583_m);
        materials.put(new ResourceLocation("shulker_shell"), Material.field_215711_w);
        materials.put(new ResourceLocation("wood"), Material.field_151575_d);
        materials.put(new ResourceLocation("nether_wood"), Material.field_237214_y_);
        materials.put(new ResourceLocation("bamboo_sapling"), Material.field_215712_y);
        materials.put(new ResourceLocation("bamboo"), Material.field_215713_z);
        materials.put(new ResourceLocation("wool"), Material.field_151580_n);
        materials.put(new ResourceLocation("explosive"), Material.field_151590_u);
        materials.put(new ResourceLocation("leaves"), Material.field_151584_j);
        materials.put(new ResourceLocation("glass"), Material.field_151592_s);
        materials.put(new ResourceLocation("ice"), Material.field_151588_w);
        materials.put(new ResourceLocation("cactus"), Material.field_151570_A);
        materials.put(new ResourceLocation("stone"), Material.field_151576_e);
        materials.put(new ResourceLocation("metal"), Material.field_151573_f);
        materials.put(new ResourceLocation("snow"), Material.field_151596_z);
        materials.put(new ResourceLocation("heavy_metal"), Material.field_151574_g);
        materials.put(new ResourceLocation("barrier"), Material.field_175972_I);
        materials.put(new ResourceLocation("piston"), Material.field_76233_E);
        materials.put(new ResourceLocation("coral"), Material.field_151589_v);
        materials.put(new ResourceLocation("vegetable"), Material.field_151572_C);
        materials.put(new ResourceLocation("egg"), Material.field_151566_D);
        materials.put(new ResourceLocation("cake"), Material.field_151568_F);
    });

    public static void registerMaterial(ResourceLocation name, Material material) {
        MATERIALS.putIfAbsent(name, material);
    }

    @Override
    public Result<Material, JsonElement> deserialise(JsonElement input) {
        return JsonDeserialisers.RESOURCE_LOCATION.deserialise(input).map(MATERIALS::get, "Could not get material from \"{}\".");
    }
}

