/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.configurations.PropertyDefinition;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.blocks.GrowableBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.compat.seasons.FlowerHoldPeriod;
import com.ferreusveritas.dynamictrees.deserialisation.AxisAlignedBBDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.BiomeListDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.BooleanFunctionDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.CodecDeserialiserWrapper;
import com.ferreusveritas.dynamictrees.deserialisation.ConfiguredDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisableClassDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.EnumDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.ForgeRegistryEntryDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.ListDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.MaterialColorDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.MaterialDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.NoSuchDeserialiserException;
import com.ferreusveritas.dynamictrees.deserialisation.PropertyDefinitionDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.RegistryEntryDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.ResourceLocationDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.SeedSaplingRecipeDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.SoundTypeDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.VoxelShapeDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.SeedSaplingRecipe;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.VinesGenFeature;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BiomeList;
import com.ferreusveritas.dynamictrees.util.ReflectionHelper;
import com.ferreusveritas.dynamictrees.util.function.BiomePredicate;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.ChanceSelectorDeserialiser;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.DensitySelectorDeserialiser;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.SpeciesSelectorDeserialiser;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class JsonDeserialisers {
    private static final Map<Class<?>, JsonDeserialiser<?>> DESERIALISERS = Maps.newHashMap();
    public static final JsonDeserialiser<?> NULL = new NullDeserialiser();
    public static final JsonDeserialiser<JsonElement> JSON_ELEMENT = JsonDeserialisers.register(JsonElement.class, input -> JsonResult.success(input, input));
    public static final JsonDeserialiser<JsonPrimitive> JSON_PRIMITIVE = JsonDeserialisers.register(JsonPrimitive.class, input -> input.isJsonPrimitive() ? JsonResult.success(input, input.getAsJsonPrimitive()) : JsonResult.failure(input, "Json element was not a json primitive."));
    public static final JsonDeserialiser<JsonObject> JSON_OBJECT = JsonDeserialisers.register(JsonObject.class, input -> input.isJsonObject() ? JsonResult.success(input, input.getAsJsonObject()) : JsonResult.failure(input, "Json element was not a json object."));
    public static final JsonDeserialiser<JsonArray> JSON_ARRAY = JsonDeserialisers.register(JsonArray.class, input -> input.isJsonArray() ? JsonResult.success(input, input.getAsJsonArray()) : JsonResult.failure(input, "Json element was not a json array."));
    public static final JsonDeserialiser<Boolean> BOOLEAN = JsonDeserialisers.register(Boolean.class, input -> JSON_PRIMITIVE.deserialise(input).mapIfValid(JsonPrimitive::isBoolean, "Could not get boolean from \"{}\".", JsonPrimitive::getAsBoolean));
    public static final JsonDeserialiser<Number> NUMBER = JsonDeserialisers.register(Number.class, input -> JSON_PRIMITIVE.deserialise(input).mapIfValid(JsonPrimitive::isNumber, "Could not get number from \"{}\".", JsonPrimitive::getAsNumber));
    public static final JsonDeserialiser<String> STRING = JsonDeserialisers.register(String.class, input -> JSON_PRIMITIVE.deserialise(input).mapIfValid(JsonPrimitive::isString, "Could not get string from \"{}\".", JsonPrimitive::getAsString));
    public static final JsonDeserialiser<Byte> BYTE = JsonDeserialisers.register(Byte.class, input -> NUMBER.deserialise(input).map(Number::byteValue));
    public static final JsonDeserialiser<Short> SHORT = JsonDeserialisers.register(Short.class, input -> NUMBER.deserialise(input).map(Number::shortValue));
    public static final JsonDeserialiser<Integer> INTEGER = JsonDeserialisers.register(Integer.class, input -> NUMBER.deserialise(input).map(Number::intValue));
    public static final JsonDeserialiser<Long> LONG = JsonDeserialisers.register(Long.class, input -> NUMBER.deserialise(input).map(Number::longValue));
    public static final JsonDeserialiser<Float> FLOAT = JsonDeserialisers.register(Float.class, input -> NUMBER.deserialise(input).map(Number::floatValue));
    public static final JsonDeserialiser<Double> DOUBLE = JsonDeserialisers.register(Double.class, input -> NUMBER.deserialise(input).map(Number::doubleValue));
    public static final JsonDeserialiser<ResourceLocation> RESOURCE_LOCATION = JsonDeserialisers.register(ResourceLocation.class, ResourceLocationDeserialiser.create());
    public static final JsonDeserialiser<ResourceLocation> DT_RESOURCE_LOCATION = ResourceLocationDeserialiser.create("dynamictrees");
    public static JsonDeserialiser<Block> BLOCK;
    public static JsonDeserialiser<Item> ITEM;
    public static JsonDeserialiser<Biome> BIOME;
    public static JsonDeserialiser<ItemStack> ITEM_STACK;
    public static final JsonDeserialiser<AxisAlignedBB> AXIS_ALIGNED_BB;
    public static final JsonDeserialiser<VoxelShape> VOXEL_SHAPE;
    public static final JsonDeserialiser<CellKit> CELL_KIT;
    public static final JsonDeserialiser<LeavesProperties> LEAVES_PROPERTIES;
    public static final JsonDeserialiser<GrowthLogicKit> GROWTH_LOGIC_KIT;
    public static final JsonDeserialiser<GenFeature> GEN_FEATURE;
    public static final JsonDeserialiser<Family> FAMILY;
    public static final JsonDeserialiser<Fruit> FRUIT;
    public static final JsonDeserialiser<Pod> POD;
    public static final JsonDeserialiser<Species> SPECIES;
    public static final JsonDeserialiser<FeatureCanceller> FEATURE_CANCELLER;
    public static final JsonDeserialiser<SoilProperties> SOIL_PROPERTIES;
    public static final JsonDeserialiser<List<SoilProperties>> SOIL_PROPERTIES_LIST;
    public static final JsonDeserialiser<GenFeatureConfiguration> CONFIGURED_GEN_FEATURE;
    public static final JsonDeserialiser<GrowthLogicKitConfiguration> CONFIGURED_GROWTH_LOGIC_KIT;
    public static final JsonDeserialiser<Seed> SEED;
    public static final JsonDeserialiser<BranchBlock> BRANCH;
    public static final JsonDeserialiser<VinesGenFeature.VineType> VINE_TYPE;
    public static final JsonDeserialiser<BiomeDatabase.Operation> OPERATION;
    public static final JsonDeserialiser<GenerationStage.Decoration> DECORATION_STAGE;
    public static final JsonDeserialiser<GrowableBlock.MatureAction> MATURE_ACTION;
    public static final JsonDeserialiser<BiomeList> BIOME_LIST;
    public static final JsonDeserialiser<BiomePredicate> BIOME_PREDICATE;
    public static final JsonDeserialiser<BiomePropertySelectors.SpeciesSelector> SPECIES_SELECTOR;
    public static final JsonDeserialiser<BiomePropertySelectors.DensitySelector> DENSITY_SELECTOR;
    public static final JsonDeserialiser<BiomePropertySelectors.ChanceSelector> CHANCE_SELECTOR;
    public static final JsonDeserialiser<SeedSaplingRecipe> SEED_SAPLING_RECIPE;
    public static final JsonDeserialiser<Material> MATERIAL;
    public static final JsonDeserialiser<MaterialColor> MATERIAL_COLOR;
    public static final JsonDeserialiser<SoundType> SOUND_TYPE;
    private static final Map<String, ToolType> TOOL_TYPES;
    public static final JsonDeserialiser<IBooleanFunction> BOOLEAN_FUNCTION;
    public static final JsonDeserialiser<ToolType> TOOL_TYPE;
    public static final JsonDeserialiser<Class<?>> DESERIALISABLE_CLASS;
    public static final JsonDeserialiser<PropertyDefinition<?>> VARIABLE_DEFINITION;
    public static final JsonDeserialiser<FlowerHoldPeriod> FLOWER_PERIOD;

    public static <T> JsonDeserialiser<T> get(Class<T> type) {
        return DESERIALISERS.getOrDefault(type, NULL);
    }

    public static <T> JsonDeserialiser<T> getOrThrow(Class<T> type) throws NoSuchDeserialiserException {
        return JsonDeserialisers.getOrThrow(type, "No Json deserialiser found for type \"" + type.getName() + "\".");
    }

    public static <T> JsonDeserialiser<T> getOrThrow(Class<T> type, String errorMessage) throws NoSuchDeserialiserException {
        JsonDeserialiser<?> deserialiser = DESERIALISERS.get(type);
        if (deserialiser == null) {
            throw new NoSuchDeserialiserException(errorMessage);
        }
        return deserialiser;
    }

    public static Set<Class<?>> getDeserialisableClasses() {
        return DESERIALISERS.keySet();
    }

    public static <T> JsonDeserialiser<T> register(Class<T> outputClass, JsonDeserialiser<T> deserialiser) {
        DESERIALISERS.put(outputClass, deserialiser);
        return deserialiser;
    }

    public static void registerForgeEntryGetters() {
        BLOCK = JsonDeserialisers.register(Block.class, new ForgeRegistryEntryDeserialiser<Block>(ForgeRegistries.BLOCKS, "block", Blocks.field_150350_a));
        ITEM = JsonDeserialisers.register(Item.class, new ForgeRegistryEntryDeserialiser<Item>(ForgeRegistries.ITEMS, "item", Items.field_190931_a));
        BIOME = JsonDeserialisers.register(Biome.class, new ForgeRegistryEntryDeserialiser(ForgeRegistries.BIOMES, "biome"));
    }

    public static void postRegistryEvent() {
        ModLoader.get().postEvent((Event)new RegistryEvent());
    }

    static {
        ITEM_STACK = JsonDeserialisers.register(ItemStack.class, input -> ITEM.deserialise(input).map(ItemStack::new));
        AXIS_ALIGNED_BB = JsonDeserialisers.register(AxisAlignedBB.class, new AxisAlignedBBDeserialiser());
        VOXEL_SHAPE = JsonDeserialisers.register(VoxelShape.class, new VoxelShapeDeserialiser());
        CELL_KIT = JsonDeserialisers.register(CellKit.class, new RegistryEntryDeserialiser<CellKit>(CellKit.REGISTRY));
        LEAVES_PROPERTIES = JsonDeserialisers.register(LeavesProperties.class, new RegistryEntryDeserialiser<LeavesProperties>(LeavesProperties.REGISTRY));
        GROWTH_LOGIC_KIT = JsonDeserialisers.register(GrowthLogicKit.class, new RegistryEntryDeserialiser(GrowthLogicKit.REGISTRY));
        GEN_FEATURE = JsonDeserialisers.register(GenFeature.class, new RegistryEntryDeserialiser(GenFeature.REGISTRY));
        FAMILY = JsonDeserialisers.register(Family.class, new RegistryEntryDeserialiser<Family>(Family.REGISTRY));
        FRUIT = JsonDeserialisers.register(Fruit.class, new RegistryEntryDeserialiser<Fruit>(Fruit.REGISTRY));
        POD = JsonDeserialisers.register(Pod.class, new RegistryEntryDeserialiser<Pod>(Pod.REGISTRY));
        SPECIES = JsonDeserialisers.register(Species.class, new RegistryEntryDeserialiser<Species>(Species.REGISTRY));
        FEATURE_CANCELLER = JsonDeserialisers.register(FeatureCanceller.class, new RegistryEntryDeserialiser<FeatureCanceller>(FeatureCanceller.REGISTRY));
        SOIL_PROPERTIES = JsonDeserialisers.register(SoilProperties.class, new RegistryEntryDeserialiser<SoilProperties>(SoilProperties.REGISTRY));
        SOIL_PROPERTIES_LIST = JsonDeserialisers.register(ListDeserialiser.getListClass(SoilProperties.class), new ListDeserialiser<SoilProperties>(SOIL_PROPERTIES));
        CONFIGURED_GEN_FEATURE = JsonDeserialisers.register(GenFeatureConfiguration.class, new ConfiguredDeserialiser<GenFeatureConfiguration, GenFeature>("Gen Feature", GenFeature.class, GenFeatureConfiguration.TEMPLATES));
        CONFIGURED_GROWTH_LOGIC_KIT = JsonDeserialisers.register(GrowthLogicKitConfiguration.class, new ConfiguredDeserialiser<GrowthLogicKitConfiguration, GrowthLogicKit>("Growth Logic Kit", GrowthLogicKit.class, GrowthLogicKitConfiguration.TEMPLATES));
        SEED = JsonDeserialisers.register(Seed.class, jsonElement -> ITEM.deserialise(jsonElement).mapIfValid(item -> item instanceof Seed, "Item \"{}\" is not a seed.", item -> (Seed)((Object)((Object)item))));
        BRANCH = JsonDeserialisers.register(BranchBlock.class, jsonElement -> BLOCK.deserialise(jsonElement).mapIfValid(block -> block instanceof BranchBlock, "Block \"{}\" is not a branch.", block -> (BranchBlock)block));
        VINE_TYPE = JsonDeserialisers.register(VinesGenFeature.VineType.class, new EnumDeserialiser<VinesGenFeature.VineType>(VinesGenFeature.VineType.class));
        OPERATION = JsonDeserialisers.register(BiomeDatabase.Operation.class, new EnumDeserialiser<BiomeDatabase.Operation>(BiomeDatabase.Operation.class));
        DECORATION_STAGE = JsonDeserialisers.register(GenerationStage.Decoration.class, new EnumDeserialiser<GenerationStage.Decoration>(GenerationStage.Decoration.class));
        MATURE_ACTION = JsonDeserialisers.register(GrowableBlock.MatureAction.class, new EnumDeserialiser<GrowableBlock.MatureAction>(GrowableBlock.MatureAction.class));
        BIOME_LIST = JsonDeserialisers.register(BiomeList.class, new BiomeListDeserialiser());
        BIOME_PREDICATE = JsonDeserialisers.register(BiomePredicate.class, jsonElement -> BIOME_LIST.deserialise(jsonElement).map(biomeList -> biome -> biomeList.stream().anyMatch(currentBiome -> Objects.equals(currentBiome.getRegistryName(), biome.getRegistryName()))));
        SPECIES_SELECTOR = JsonDeserialisers.register(BiomePropertySelectors.SpeciesSelector.class, new SpeciesSelectorDeserialiser());
        DENSITY_SELECTOR = JsonDeserialisers.register(BiomePropertySelectors.DensitySelector.class, new DensitySelectorDeserialiser());
        CHANCE_SELECTOR = JsonDeserialisers.register(BiomePropertySelectors.ChanceSelector.class, new ChanceSelectorDeserialiser());
        SEED_SAPLING_RECIPE = JsonDeserialisers.register(SeedSaplingRecipe.class, new SeedSaplingRecipeDeserialiser());
        MATERIAL = JsonDeserialisers.register(Material.class, new MaterialDeserialiser());
        MATERIAL_COLOR = JsonDeserialisers.register(MaterialColor.class, new MaterialColorDeserialiser());
        SOUND_TYPE = JsonDeserialisers.register(SoundType.class, new SoundTypeDeserialiser());
        TOOL_TYPES = (Map)ReflectionHelper.getPrivateFieldUnchecked(ToolType.class, "VALUES");
        BOOLEAN_FUNCTION = JsonDeserialisers.register(IBooleanFunction.class, new BooleanFunctionDeserialiser());
        TOOL_TYPE = JsonDeserialisers.register(ToolType.class, jsonElement -> STRING.deserialise(jsonElement).map(TOOL_TYPES::get, "Could not get tool type from \"{}\"."));
        DESERIALISABLE_CLASS = new DeserialisableClassDeserialiser();
        VARIABLE_DEFINITION = JsonDeserialisers.register(PropertyDefinition.captureClass(), new PropertyDefinitionDeserialiser());
        FLOWER_PERIOD = JsonDeserialisers.register(FlowerHoldPeriod.class, new CodecDeserialiserWrapper<FlowerHoldPeriod>(FlowerHoldPeriod.CODEC));
    }

    public static final class RegistryEvent
    extends Event
    implements IModBusEvent {
    }

    private static final class NullDeserialiser<O>
    implements JsonDeserialiser<O> {
        private NullDeserialiser() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean deserialiseIfValid(JsonElement input, Consumer<Result<O, JsonElement>> consumer) {
            return false;
        }

        @Override
        public Result<O, JsonElement> deserialise(JsonElement input) {
            return JsonResult.failure(input, "Could not get Json deserialiser for json element: " + input + ".");
        }
    }
}

