/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat.seasons;

import com.ferreusveritas.dynamictrees.api.seasons.ClimateZoneType;
import com.ferreusveritas.dynamictrees.api.seasons.SeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.api.seasons.SeasonManager;
import com.ferreusveritas.dynamictrees.compat.seasons.NullSeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.compat.seasons.NullSeasonProvider;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonContext;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class NormalSeasonManager
implements SeasonManager {
    public static final Supplier<NormalSeasonManager> NULL = NormalSeasonManager::new;
    private final Map<ResourceLocation, SeasonContext> seasonContextMap = new HashMap<ResourceLocation, SeasonContext>();
    private Function<World, Tuple<SeasonProvider, SeasonGrowthCalculator>> seasonMapper = w -> new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator());
    private static final float TROPICAL_THRESHHOLD = 0.8f;
    private BiPredicate<IWorld, BlockPos> isTropical = (world, rootPos) -> world.func_225604_a_(rootPos.func_177958_n() >> 2, rootPos.func_177956_o() >> 2, rootPos.func_177952_p() >> 2).func_242445_k() > 0.8f;

    public NormalSeasonManager() {
    }

    public NormalSeasonManager(Function<World, Tuple<SeasonProvider, SeasonGrowthCalculator>> seasonMapper) {
        this.seasonMapper = seasonMapper;
    }

    private Tuple<SeasonProvider, SeasonGrowthCalculator> createProvider(World world) {
        return this.seasonMapper.apply(world);
    }

    private SeasonContext getContext(World world) {
        return this.seasonContextMap.computeIfAbsent(world.func_234923_W_().func_240901_a_(), d -> {
            Tuple<SeasonProvider, SeasonGrowthCalculator> tuple = this.createProvider(world);
            return new SeasonContext((SeasonProvider)tuple.func_76341_a(), (SeasonGrowthCalculator)tuple.func_76340_b());
        });
    }

    @Override
    public void flushMappings() {
        this.seasonContextMap.clear();
    }

    public void setTropicalPredicate(BiPredicate<IWorld, BlockPos> predicate) {
        this.isTropical = predicate;
    }

    @Override
    public boolean isTropical(IWorld world, BlockPos rootPos) {
        return this.isTropical.test(world, rootPos);
    }

    @Override
    public void updateTick(World world, long worldTicks) {
        this.getContext(world).updateTick(world, worldTicks);
    }

    @Override
    public float getGrowthFactor(World world, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(world);
        return this.isTropical((IWorld)world, rootPos) ? context.getTropicalGrowthFactor(offset) : context.getTemperateGrowthFactor(offset);
    }

    @Override
    public float getSeedDropFactor(World world, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(world);
        return this.isTropical((IWorld)world, rootPos) ? context.getTropicalSeedDropFactor(offset) : context.getTemperateSeedDropFactor(offset);
    }

    @Override
    public float getFruitProductionFactor(World world, BlockPos rootPos, float offset, boolean getAsScan) {
        if (getAsScan) {
            return this.getFruitProductionFactorAsScan(world.func_234923_W_().func_240901_a_(), rootPos, offset);
        }
        SeasonContext context = this.getContext(world);
        return this.isTropical((IWorld)world, rootPos) ? context.getTropicalFruitProductionFactor(offset) : context.getTemperateFruitProductionFactor(offset);
    }

    @Override
    public Float getSeasonValue(World world, BlockPos pos) {
        return this.getContext(world).getSeasonProvider().getSeasonValue(world, pos);
    }

    @Override
    public Float getPeakFruitProductionSeasonValue(World world, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(world);
        return this.isTropical((IWorld)world, rootPos) ? context.getTropicalPeakFruitProductionSeasonValue(offset) : context.getTemperatePeakFruitProductionSeasonValue(offset);
    }

    @Override
    public boolean shouldSnowMelt(World world, BlockPos pos) {
        return this.getContext(world).getSeasonProvider().shouldSnowMelt(world, pos);
    }

    public float getFruitProductionFactorAsScan(ResourceLocation dimLoc, BlockPos rootPos, float offset) {
        if (this.seasonContextMap.size() > 0) {
            boolean tropical;
            float seasonValue = (float)rootPos.func_177956_o() / 64.0f;
            boolean bl = tropical = (float)rootPos.func_177952_p() >= 1.0f;
            if (this.seasonContextMap.containsKey(dimLoc)) {
                SeasonContext context = this.seasonContextMap.get(dimLoc);
                SeasonGrowthCalculator calculator = context.getCalculator();
                return calculator.calcFruitProduction(Float.valueOf(seasonValue + offset), tropical ? ClimateZoneType.TROPICAL : ClimateZoneType.TEMPERATE);
            }
        }
        return 0.0f;
    }
}

