/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat;

import com.ferreusveritas.dynamictrees.compat.seasons.ActiveSeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.compat.seasons.BetterWeatherSeasonProvider;
import com.ferreusveritas.dynamictrees.compat.seasons.NormalSeasonManager;
import com.ferreusveritas.dynamictrees.compat.seasons.NullSeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.compat.seasons.NullSeasonProvider;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.compat.seasons.SereneSeasonsSeasonProvider;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.google.common.collect.Maps;
import corgitaco.betterweather.api.season.Season;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;

public final class CompatHandler {
    private static final LinkedHashMap<String, Supplier<NormalSeasonManager>> SEASON_MANAGERS = Maps.newLinkedHashMap();
    public static final String DISABLED = "!";
    public static final String ANY = "*";

    public static void registerSeasonManager(String modId, Supplier<NormalSeasonManager> supplier) {
        SEASON_MANAGERS.put(modId, supplier);
    }

    public static void registerBuiltInSeasonManagers() {
        CompatHandler.registerSeasonManager("sereneseasons", () -> {
            NormalSeasonManager seasonManager = new NormalSeasonManager(world -> SeasonsConfig.isDimensionWhitelisted((RegistryKey)world.func_234923_W_()) ? new Tuple((Object)new SereneSeasonsSeasonProvider(), (Object)new ActiveSeasonGrowthCalculator()) : new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator()));
            seasonManager.setTropicalPredicate((world, pos) -> {
                ResourceLocation registryName = world.func_226691_t_(pos).getRegistryName();
                return registryName != null && BiomeConfig.usesTropicalSeasons((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)registryName));
            });
            return seasonManager;
        });
        CompatHandler.registerSeasonManager("betterweather", () -> new NormalSeasonManager(world -> Season.getSeason((World)world) == null ? new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator()) : new Tuple((Object)new BetterWeatherSeasonProvider(), (Object)new ActiveSeasonGrowthCalculator())));
    }

    public static void reloadSeasonManager() {
        String modId = (String)DTConfigs.PREFERRED_SEASON_MOD.get();
        if (Objects.equals(modId, DISABLED)) {
            SeasonHelper.setSeasonManager(NormalSeasonManager.NULL.get());
            return;
        }
        if (Objects.equals(modId, ANY)) {
            SeasonHelper.setSeasonManager(SEASON_MANAGERS.entrySet().stream().filter(entry -> ModList.get().isLoaded((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(NormalSeasonManager.NULL).get());
            return;
        }
        if (!ModList.get().isLoaded(modId)) {
            LogManager.getLogger().warn("Preferred season mod \"{}\" not installed.", (Object)modId);
            return;
        }
        if (!SEASON_MANAGERS.containsKey(modId)) {
            LogManager.getLogger().warn("Season manager not found for preferred season mod \"{}\".", (Object)modId);
            return;
        }
        SeasonHelper.setSeasonManager(SEASON_MANAGERS.get(modId).get());
    }
}

