/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.ThrowableRunnable;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class SubCommand {
    protected static final DynamicCommandExceptionType NO_TREE_FOUND = new DynamicCommandExceptionType(pos -> new TranslationTextComponent("commands.dynamictrees.error.get_tree", new Object[]{new TranslationTextComponent("chat.coordinates", new Object[]{SubCommand.getVector3i(pos).func_177958_n(), SubCommand.getVector3i(pos).func_177956_o(), SubCommand.getVector3i(pos).func_177952_p()}).func_240700_a_(style -> style.func_240712_a_(TextFormatting.DARK_RED))}));
    protected static final DynamicCommandExceptionType SPECIES_UNKNOWN = new DynamicCommandExceptionType(resLocStr -> new TranslationTextComponent("commands.dynamictrees.error.unknown_species", new Object[]{SubCommand.darkRed(resLocStr)}));
    protected static final DynamicCommandExceptionType SPECIES_NOT_TRANSFORMABLE = new DynamicCommandExceptionType(nonTransformableSpecies -> new TranslationTextComponent("commands.dynamictrees.error.not_transformable", new Object[]{SubCommand.darkRed(nonTransformableSpecies)}));

    private static Vector3i getVector3i(Object vecObj) {
        if (vecObj instanceof Vector3i) {
            return (Vector3i)vecObj;
        }
        return Vector3i.field_177959_e;
    }

    protected abstract String getName();

    protected abstract int getPermissionLevel();

    public ArgumentBuilder<CommandSource, ?> register() {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(commandSource -> commandSource.func_197034_c(this.getPermissionLevel()));
        this.registerArguments().forEach(arg_0 -> ((LiteralArgumentBuilder)argumentBuilder).then(arg_0));
        return argumentBuilder;
    }

    protected List<ArgumentBuilder<CommandSource, ?>> registerArguments() {
        return Lists.newArrayList((Object[])new ArgumentBuilder[]{this.registerArgument()});
    }

    public abstract ArgumentBuilder<CommandSource, ?> registerArgument();

    protected static int executesSuccess(ThrowableRunnable<CommandSyntaxException> executeRunnable) throws CommandSyntaxException {
        executeRunnable.run();
        return 1;
    }

    protected static int executesSuccess(CommandContext<CommandSource> context, Consumer<CommandContext<CommandSource>> executeConsumer) {
        executeConsumer.accept(context);
        return 1;
    }

    protected static RequiredArgumentBuilder<CommandSource, Boolean> booleanArgument(String name) {
        return Commands.func_197056_a((String)name, (ArgumentType)BoolArgumentType.bool());
    }

    protected static boolean booleanArgument(CommandContext<CommandSource> context, String name) {
        return BoolArgumentType.getBool(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSource, Integer> intArgument(String name) {
        return Commands.func_197056_a((String)name, (ArgumentType)IntegerArgumentType.integer());
    }

    protected static int intArgument(CommandContext<CommandSource> context, String name) {
        return IntegerArgumentType.getInteger(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSource, String> stringArgument(String name) {
        return Commands.func_197056_a((String)name, (ArgumentType)StringArgumentType.string());
    }

    protected static RequiredArgumentBuilder<CommandSource, String> stringArgument(String name, Collection<String> suggestions) {
        return Commands.func_197056_a((String)name, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197005_b((Iterable)suggestions, (SuggestionsBuilder)builder));
    }

    protected static String stringArgument(CommandContext<CommandSource> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSource, ILocationArgument> blockPosArgument() {
        return Commands.func_197056_a((String)"location", (ArgumentType)BlockPosArgument.func_197276_a());
    }

    protected static BlockPos blockPosArgument(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return BlockPosArgument.func_197273_a(context, (String)"location");
    }

    protected static BlockPos rootPosArgument(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos pos = SubCommand.blockPosArgument(context);
        BlockPos rootPos = TreeHelper.findRootNode((World)((CommandSource)context.getSource()).func_197023_e(), pos);
        if (rootPos == BlockPos.field_177992_a) {
            throw NO_TREE_FOUND.create((Object)pos);
        }
        return rootPos;
    }

    protected static RequiredArgumentBuilder<CommandSource, ResourceLocation> speciesArgument() {
        return SubCommand.resourceLocationArgument("species", Species.REGISTRY::getRegistryNames);
    }

    protected static RequiredArgumentBuilder<CommandSource, ResourceLocation> transformableSpeciesArgument() {
        return SubCommand.resourceLocationArgument("species", TreeRegistry::getTransformableSpeciesLocations);
    }

    protected static Species speciesArgument(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ResourceLocation registryName = ResourceLocationArgument.func_197195_e(context, (String)"species");
        Species species = TreeRegistry.findSpecies(registryName);
        if (!species.isValid()) {
            throw SPECIES_UNKNOWN.create((Object)registryName.toString());
        }
        return species;
    }

    protected static RequiredArgumentBuilder<CommandSource, ResourceLocation> resourceLocationArgument(String name, Supplier<Collection<ResourceLocation>> suggestionsSupplier) {
        return Commands.func_197056_a((String)name, (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests((context, builder) -> ISuggestionProvider.func_197014_a((Iterable)((Iterable)suggestionsSupplier.get()), (SuggestionsBuilder)builder));
    }

    protected static ITextComponent aqua(Object object) {
        return CommandHelper.colour(object, TextFormatting.AQUA);
    }

    protected static ITextComponent darkRed(Object object) {
        return CommandHelper.colour(object, TextFormatting.DARK_RED);
    }

    protected static void sendSuccess(CommandSource source, ITextComponent component) {
        source.func_197030_a((ITextComponent)component.func_230532_e_().func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN)), false);
    }

    protected static void sendSuccessAndLog(CommandSource source, ITextComponent component) {
        source.func_197030_a((ITextComponent)component.func_230532_e_().func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN)), true);
    }

    protected static void sendFailure(CommandSource source, ITextComponent component) {
        source.func_197021_a((ITextComponent)component.func_230532_e_().func_240700_a_(style -> style.func_240712_a_(TextFormatting.RED)));
    }
}

