/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.CommandConstants;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.Null;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class SetTreeCommand
extends SubCommand {
    private static final int DEFAULT_FERTILITY = 0;

    @Override
    protected String getName() {
        return "settree";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return SetTreeCommand.blockPosArgument().then(((RequiredArgumentBuilder)SetTreeCommand.speciesArgument().executes(context -> this.setTree((CommandSource)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSource>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSource>)context), "jo_code", 0, 0))).then(((RequiredArgumentBuilder)SetTreeCommand.stringArgument("jo_code").suggests((context, builder) -> ISuggestionProvider.func_197005_b((Iterable)SetTreeCommand.speciesArgument((CommandContext<CommandSource>)context).getJoCodes().stream().map(JoCode::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.setTree((CommandSource)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSource>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSource>)context), SetTreeCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), 0, 0))).then(((RequiredArgumentBuilder)SetTreeCommand.intArgument("turns").suggests(CommandConstants.TURNS_SUGGESTIONS).executes(context -> this.setTree((CommandSource)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSource>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSource>)context), SetTreeCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSource>)context, "turns"), 0))).then(SetTreeCommand.intArgument("fertility").suggests(CommandConstants.FERTILITY_SUGGESTIONS).executes(context -> this.setTree((CommandSource)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSource>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSource>)context), SetTreeCommand.stringArgument((CommandContext<CommandSource>)context, "jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSource>)context, "turns"), SetTreeCommand.intArgument((CommandContext<CommandSource>)context, "fertility")))))));
    }

    private int setTree(CommandSource source, BlockPos rootPos, Species species, String codeString, int turns, int fertility) {
        ServerWorld world = source.func_197023_e();
        JoCode joCode = species.getJoCode(codeString).rotate(Direction.func_176731_b((int)(3 - turns % 4 + 3))).setCareful(true);
        SetTreeCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.set_tree", new Object[]{CommandHelper.posComponent((Vector3i)rootPos), species.getTextComponent(), joCode.getTextComponent()}));
        joCode.generate(WorldContext.create((IWorld)world), species, rootPos, source.func_197023_e().func_226691_t_(rootPos), Direction.SOUTH, 8, SafeChunkBounds.ANY, false);
        Null.consumeIfNonnull(TreeHelper.getRooty(world.func_180495_p(rootPos)), rootyBlock -> rootyBlock.setFertility((World)world, rootPos, fertility));
        return 1;
    }
}

