/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class KillTreeCommand
extends SubCommand {
    @Override
    protected String getName() {
        return "killtree";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return KillTreeCommand.blockPosArgument().executes(context -> KillTreeCommand.executesSuccess(() -> this.killTree((CommandSource)context.getSource(), KillTreeCommand.rootPosArgument((CommandContext<CommandSource>)context))));
    }

    private void killTree(CommandSource source, BlockPos rootPos) {
        ServerWorld world = source.func_197023_e();
        Objects.requireNonNull(TreeHelper.getRooty(world.func_180495_p(rootPos))).destroyTree((World)world, rootPos);
        KillTreeCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.kill_tree", new Object[]{CommandHelper.posComponent((Vector3i)rootPos, TextFormatting.AQUA)}));
    }
}

