/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class CreateTransformPotionCommand
extends SubCommand {
    @Override
    protected String getName() {
        return "createtransformpotion";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return CreateTransformPotionCommand.blockPosArgument().then(CreateTransformPotionCommand.transformableSpeciesArgument().executes(context -> this.spawnTransformPotion((CommandSource)context.getSource(), CreateTransformPotionCommand.blockPosArgument((CommandContext<CommandSource>)context), CreateTransformPotionCommand.speciesArgument((CommandContext<CommandSource>)context))));
    }

    private int spawnTransformPotion(CommandSource source, BlockPos pos, Species species) throws CommandSyntaxException {
        if (!species.isTransformable()) {
            throw SPECIES_NOT_TRANSFORMABLE.create((Object)species.getTextComponent());
        }
        DendroPotion dendroPotion = DTRegistries.DENDRO_POTION;
        ItemStack dendroPotionStack = new ItemStack((IItemProvider)dendroPotion);
        dendroPotion.applyIndexTag(dendroPotionStack, DendroPotion.DendroPotionType.TRANSFORM.getIndex());
        dendroPotion.setTargetSpecies(dendroPotionStack, species);
        ItemUtils.spawnItemStack((World)source.func_197023_e(), pos, dendroPotionStack, true);
        CreateTransformPotionCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.create_transform_potion", new Object[]{species.getTextComponent(), CommandHelper.posComponent((Vector3i)pos, TextFormatting.AQUA)}));
        return 1;
    }
}

