/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client.thickrings;

import com.ferreusveritas.dynamictrees.client.thickrings.ThickRingAtlasTexture;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;

public class ThickRingTextureManager {
    public static final ResourceLocation LOCATION_THICKRINGS_TEXTURE = new ResourceLocation("dynamictrees", "textures/atlas/thick_rings.png");
    public static ThickRingAtlasTexture textureAtlas;
    public static AtlasTexture.SheetData thickRingData;
    private static final BiMap<ResourceLocation, ResourceLocation> thickRingTextures;

    public static ResourceLocation addRingTextureLocation(ResourceLocation ringsRes) {
        ResourceLocation thickRingSet = new ResourceLocation(ringsRes.func_110624_b(), ringsRes.func_110623_a() + "_thick");
        thickRingTextures.put((Object)ringsRes, (Object)thickRingSet);
        return thickRingSet;
    }

    public static Set<ResourceLocation> getThickRingResourceLocations() {
        return new HashSet<ResourceLocation>(thickRingTextures.values());
    }

    public static Set<Map.Entry<ResourceLocation, ResourceLocation>> getThickRingEntrySet() {
        return thickRingTextures.entrySet();
    }

    public static ResourceLocation getThickRingFromBaseRing(ResourceLocation baseRing) {
        return (ResourceLocation)thickRingTextures.get((Object)baseRing);
    }

    public static ResourceLocation getBaseRingFromThickRing(ResourceLocation thickRing) {
        return (ResourceLocation)thickRingTextures.inverse().get((Object)thickRing);
    }

    static {
        thickRingTextures = HashBiMap.create();
    }
}

