/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.rootyblocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.data.WaterRootGenerator;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class WaterSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(WaterSoilProperties::new);

    public WaterSoilProperties(ResourceLocation registryName) {
        super(null, registryName);
        this.soilStateGenerator.reset(WaterRootGenerator::new);
    }

    @Override
    protected RootyBlock createBlock(AbstractBlock.Properties blockProperties) {
        return new RootyWaterBlock(this, blockProperties);
    }

    @Override
    public Material getDefaultMaterial() {
        return Material.field_151586_h;
    }

    @Override
    public AbstractBlock.Properties getDefaultBlockProperties(Material material, MaterialColor materialColor) {
        return AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150355_j);
    }

    public static class RootyWaterBlock
    extends RootyBlock
    implements IWaterLoggable {
        protected static final AxisAlignedBB WATER_ROOTS_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

        public RootyWaterBlock(SoilProperties properties, AbstractBlock.Properties blockProperties) {
            super(properties, blockProperties);
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new Property[]{WATERLOGGED}));
        }

        @Override
        public int getRadiusForConnection(BlockState state, IBlockReader reader, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
            return 1;
        }

        @Override
        public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
            BlockState upState = world.func_180495_p(pos.func_177984_a());
            if (TreeHelper.isBranch(upState)) {
                return TreeHelper.getBranch(upState).getFamily().getBranchItem().map(ItemStack::new).orElse(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public float getHardness(BlockState state, IBlockReader worldIn, BlockPos pos) {
            return (float)(0.5 * (Double)DTConfigs.ROOTY_BLOCK_HARDNESS_MULTIPLIER.get());
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            return VoxelShapes.func_197881_a((AxisAlignedBB)WATER_ROOTS_AABB);
        }

        public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
            return VoxelShapes.func_197880_a();
        }

        public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
            return false;
        }

        public FluidState func_204507_t(BlockState state) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
        }

        public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }

        @Override
        public BlockState getDecayBlockState(BlockState state, IBlockReader access, BlockPos pos) {
            if (state.func_235901_b_((Property)WATERLOGGED) && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return super.getDecayBlockState(state, access, pos);
        }

        @Override
        public boolean getColorFromBark() {
            return true;
        }

        @Override
        public boolean fallWithTree(BlockState state, World world, BlockPos pos) {
            world.func_175656_a(pos, this.getDecayBlockState(state, (IBlockReader)world, pos));
            return true;
        }
    }
}

