/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.rootyblocks;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.init.DTClient;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpreadableSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(SpreadableSoilProperties::new);
    private Integer required_light = null;
    private Item spread_item = null;
    private final List<SoilProperties> spreadable_soils = new LinkedList<SoilProperties>();

    public void setRequiredLight(Integer light) {
        this.required_light = light;
    }

    public void setSpreadItem(Item item) {
        this.spread_item = item;
    }

    public SpreadableSoilProperties(ResourceLocation registryName) {
        super(null, registryName);
    }

    @Override
    protected RootyBlock createBlock(AbstractBlock.Properties blockProperties) {
        return new SpreadableRootyBlock(this, blockProperties);
    }

    public void addSpreadableSoils(Block ... blocks) {
        for (Block block : blocks) {
            SoilProperties props = SoilHelper.getProperties(block);
            if (!props.isValid()) continue;
            this.spreadable_soils.add(props);
        }
    }

    public void addSpreadableSoils(SoilProperties ... props) {
        this.spreadable_soils.addAll(Arrays.asList(props));
    }

    public static class SpreadableRootyBlock
    extends RootyBlock {
        public SpreadableRootyBlock(SpreadableSoilProperties properties, AbstractBlock.Properties blockProperties) {
            super(properties, blockProperties);
        }

        @Override
        public SpreadableSoilProperties getSoilProperties() {
            return (SpreadableSoilProperties)super.getSoilProperties();
        }

        private Optional<RootyBlock> getRootyBlock(Block block) {
            return SoilHelper.getProperties(block).getBlock();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            ItemStack handStack;
            SpreadableSoilProperties properties = this.getSoilProperties();
            if (properties.spread_item != null && (handStack = player.func_184586_b(hand)).func_77973_b().equals(properties.spread_item)) {
                LinkedList<Block> foundBlocks = new LinkedList<Block>();
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
                    Block block = world.func_180495_p(blockpos).func_177230_c();
                    if (!properties.spreadable_soils.stream().anyMatch(prop -> prop.getPrimitiveSoilBlock() == block)) continue;
                    foundBlocks.add(block);
                }
                if (foundBlocks.size() > 0) {
                    if (!world.func_201670_d()) {
                        int blockInt = world.field_73012_v.nextInt(foundBlocks.size());
                        this.getRootyBlock((Block)foundBlocks.get(blockInt)).ifPresent(rootyBlock -> world.func_180501_a(pos, rootyBlock.func_176223_P(), 3));
                    }
                    if (!player.func_184812_l_()) {
                        handStack.func_190918_g(1);
                    }
                    DTClient.spawnParticles(world, ParticleTypes.field_197632_y, pos.func_177984_a(), 2 + world.field_73012_v.nextInt(5), world.field_73012_v);
                    return ActionResultType.SUCCESS;
                }
            }
            return super.func_225533_a_(state, world, pos, player, hand, hit);
        }

        @Override
        public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
            super.func_225542_b_(state, world, pos, random);
            SpreadableSoilProperties properties = this.getSoilProperties();
            if (!world.field_72995_K && properties.required_light != null) {
                if (!world.isAreaLoaded(pos, 3)) {
                    return;
                }
                if (world.func_201696_r(pos.func_177984_a()) >= properties.required_light) {
                    for (int i = 0; i < 4; ++i) {
                        BlockPos thatPos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                        if (thatPos.func_177956_o() >= 0 && thatPos.func_177956_o() < 256 && !world.func_175667_e(thatPos)) {
                            return;
                        }
                        BlockState thatStateUp = world.func_180495_p(thatPos.func_177984_a());
                        BlockState thatState = world.func_180495_p(thatPos);
                        for (SoilProperties spreadable : properties.spreadable_soils) {
                            RootyBlock block = spreadable.getBlock().orElse(null);
                            if (block == null || thatState.func_177230_c() != spreadable.getPrimitiveSoilBlock() && thatState.func_177230_c() != block || world.func_201696_r(pos.func_177984_a()) < properties.required_light || thatStateUp.func_200016_a((IBlockReader)world, thatPos.func_177984_a()) > 2) continue;
                            if (state.func_235901_b_((Property)FERTILITY)) {
                                world.func_175656_a(pos, (BlockState)block.func_176223_P().func_206870_a((Property)FERTILITY, state.func_177229_b((Property)FERTILITY)));
                            }
                            return;
                        }
                    }
                }
            }
        }
    }
}

