/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.leaves;

import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.LeavesStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.client.BlockColorMultipliers;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Resettable;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.LootTableSupplier;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.ToolTypes;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class LeavesProperties
extends RegistryEntry<LeavesProperties>
implements Resettable<LeavesProperties> {
    public static final Codec<LeavesProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, LeavesProperties::new));
    public static final LeavesProperties NULL = ((LeavesProperties)new LeavesProperties(){

        @Override
        public LeavesProperties setFamily(Family family) {
            return this;
        }

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public BlockState getPrimitiveLeaves() {
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public ItemStack getPrimitiveLeavesItemStack() {
            return ItemStack.field_190927_a;
        }

        @Override
        public LeavesProperties setDynamicLeavesState(BlockState state) {
            return this;
        }

        @Override
        public BlockState getDynamicLeavesState() {
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public BlockState getDynamicLeavesState(int hydro) {
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public CellKit getCellKit() {
            return CellKit.NULL_CELL_KIT;
        }

        @Override
        public int getFlammability() {
            return 0;
        }

        @Override
        public int getFireSpreadSpeed() {
            return 0;
        }

        @Override
        public int getSmotherLeavesMax() {
            return 0;
        }

        @Override
        public int getLightRequirement() {
            return 15;
        }

        @Override
        public boolean updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
            return false;
        }
    }.setRegistryName(DTTrees.NULL)).setBlockRegistryName(DTTrees.NULL);
    public static final TypedRegistry<LeavesProperties> REGISTRY = new TypedRegistry<LeavesProperties>(LeavesProperties.class, NULL, new TypedRegistry.EntryType<LeavesProperties>(CODEC));
    protected static final int maxHydro = 7;
    protected BlockState primitiveLeaves;
    protected CellKit cellKit;
    protected Family family;
    protected BlockState[] dynamicLeavesBlockHydroStates = new BlockState[8];
    protected int flammability = 60;
    protected int fireSpreadSpeed = 30;
    protected int smotherLeavesMax = 4;
    protected int lightRequirement = 13;
    protected AgeingConfiguration ageingConfiguration = AgeingConfiguration.ALWAYS;
    protected boolean connectAnyRadius = false;
    protected boolean canBeSheared = true;
    private ResourceLocation blockRegistryName;
    private boolean canGrowOnGround = false;
    protected float[] seedDropChances = new float[]{0.015625f, 0.03125f, 0.046875f, 0.0625f};
    private final LootTableSupplier blockLootTableSupplier;
    private final LootTableSupplier lootTableSupplier;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, LeavesProperties>> stateGenerator = MutableLazyValue.supplied(LeavesStateGenerator::new);
    protected Integer colorNumber;
    protected String colorString;
    @OnlyIn(value=Dist.CLIENT)
    private IBlockColor colorMultiplier;

    private LeavesProperties() {
        this.blockLootTableSupplier = new LootTableSupplier("null/", DTTrees.NULL);
        this.lootTableSupplier = new LootTableSupplier("null/", DTTrees.NULL);
    }

    public LeavesProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public LeavesProperties(@Nullable BlockState primitiveLeaves, ResourceLocation registryName) {
        this(primitiveLeaves, CellKits.DECIDUOUS, registryName);
    }

    public LeavesProperties(@Nullable BlockState primitiveLeaves, CellKit cellKit, ResourceLocation registryName) {
        this.family = Family.NULL_FAMILY;
        this.primitiveLeaves = primitiveLeaves != null ? primitiveLeaves : BlockStates.AIR;
        this.cellKit = cellKit;
        this.setRegistryName(registryName);
        this.blockRegistryName = ResourceLocationUtils.suffix(registryName, this.getBlockRegistryNameSuffix());
        this.blockLootTableSupplier = new LootTableSupplier("blocks/", this.blockRegistryName);
        this.lootTableSupplier = new LootTableSupplier("trees/leaves/", registryName);
    }

    public BlockState getPrimitiveLeaves() {
        return this.primitiveLeaves;
    }

    public Optional<Block> getPrimitiveLeavesBlock() {
        if (this.primitiveLeaves == null) {
            return Optional.empty();
        }
        return Optionals.ofBlock(this.primitiveLeaves.func_177230_c());
    }

    public void setPrimitiveLeaves(Block primitiveLeaves) {
        if (this.primitiveLeaves == null || primitiveLeaves != this.primitiveLeaves.func_177230_c()) {
            this.primitiveLeaves = primitiveLeaves.func_176223_P();
        }
    }

    public ItemStack getPrimitiveLeavesItemStack() {
        return new ItemStack((IItemProvider)Item.field_179220_a.get(this.getPrimitiveLeaves().func_177230_c()));
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public LeavesProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    public String getBlockRegistryNameSuffix() {
        return "_leaves";
    }

    public Optional<DynamicLeavesBlock> getDynamicLeavesBlock() {
        Block block = this.getDynamicLeavesState().func_177230_c();
        return Optional.ofNullable(block instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)block : null);
    }

    protected DynamicLeavesBlock createDynamicLeaves(AbstractBlock.Properties properties) {
        return new DynamicLeavesBlock(this, properties);
    }

    public void generateDynamicLeaves(AbstractBlock.Properties properties) {
        RegistryHandler.addBlock(this.blockRegistryName, this.createDynamicLeaves(properties));
    }

    public LeavesProperties setDynamicLeavesState(BlockState state) {
        this.dynamicLeavesBlockHydroStates[0] = Blocks.field_150350_a.func_176223_P();
        for (int i = 1; i <= 7; ++i) {
            this.dynamicLeavesBlockHydroStates[i] = (BlockState)state.func_206870_a((Property)DynamicLeavesBlock.field_208494_a, (Comparable)Integer.valueOf(i));
        }
        return this;
    }

    public BlockState getDynamicLeavesState() {
        return this.getDynamicLeavesState(this.getCellKit().getDefaultHydration());
    }

    public BlockState getDynamicLeavesState(int hydro) {
        return Optional.ofNullable(this.dynamicLeavesBlockHydroStates[MathHelper.func_76125_a((int)hydro, (int)0, (int)7)]).orElse(Blocks.field_150350_a.func_176223_P());
    }

    public Family getFamily() {
        return this.family;
    }

    public LeavesProperties setFamily(Family family) {
        this.family = family;
        if (family.isFireProof()) {
            this.flammability = 0;
            this.fireSpreadSpeed = 0;
        }
        return this;
    }

    public int getFlammability() {
        return this.flammability;
    }

    public void setFlammability(int flammability) {
        this.flammability = flammability;
    }

    public int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    public void setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
    }

    public int getSmotherLeavesMax() {
        return this.smotherLeavesMax;
    }

    public void setSmotherLeavesMax(int smotherLeavesMax) {
        this.smotherLeavesMax = smotherLeavesMax;
    }

    public int getLightRequirement() {
        return this.lightRequirement;
    }

    public void setLightRequirement(int lightRequirement) {
        this.lightRequirement = lightRequirement;
    }

    public boolean getDoesAge(boolean worldGen, BlockState state) {
        return this.shouldAge(worldGen, state);
    }

    public boolean shouldAge(boolean worldGen, BlockState state) {
        return this.ageingConfiguration.shouldAge(worldGen);
    }

    @Deprecated
    public void setDoesAge(String doesAge) {
        try {
            this.ageingConfiguration = AgeingConfiguration.valueOf(doesAge.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid ageing configuration \"" + doesAge + "\".");
        }
    }

    public void setAgeingConfiguration(AgeingConfiguration doesAge) {
        this.ageingConfiguration = doesAge;
    }

    public void setCanGrowOnGround(boolean canGrowOnGround) {
        this.canGrowOnGround = canGrowOnGround;
    }

    public boolean canGrowOnGround() {
        return this.canGrowOnGround;
    }

    public CellKit getCellKit() {
        return this.cellKit;
    }

    public void setCellKit(CellKit cellKit) {
        this.cellKit = cellKit;
    }

    public boolean isConnectAnyRadius() {
        return this.connectAnyRadius;
    }

    public void setConnectAnyRadius(boolean connectAnyRadius) {
        this.connectAnyRadius = connectAnyRadius;
    }

    public Material getDefaultMaterial() {
        return Material.field_151584_j;
    }

    public AbstractBlock.Properties getDefaultBlockProperties(Material material, MaterialColor materialColor) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200943_b(0.2f).harvestTool(ToolTypes.SHEARS).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_((s, r, p, e) -> e == EntityType.field_200781_U || e == EntityType.field_200783_W).func_235842_b_((s, r, p) -> false).func_235847_c_((s, r, p) -> false);
    }

    public void setSeedDropChances(float[] seedDropChances) {
        this.seedDropChances = seedDropChances;
    }

    public void setSeedDropChances(Collection<Float> seedDropChances) {
        this.seedDropChances = new float[seedDropChances.size()];
        Iterator<Float> iterator = seedDropChances.iterator();
        for (int i = 0; i < seedDropChances.size(); ++i) {
            this.seedDropChances[i] = iterator.next().floatValue();
        }
    }

    public ResourceLocation getBlockLootTableName() {
        return this.blockLootTableSupplier.getName();
    }

    public LootTable getBlockLootTable(LootTableManager lootTableManager, Species species) {
        return this.blockLootTableSupplier.get(lootTableManager, species);
    }

    public boolean shouldGenerateBlockDrops() {
        return this.shouldGenerateDrops();
    }

    public LootTable.Builder createBlockDrops() {
        if (this.primitiveLeaves != null && this.getPrimitiveLeavesBlock().isPresent()) {
            return DTLootTableProvider.createLeavesBlockDrops(this.primitiveLeaves.func_177230_c(), this.seedDropChances);
        }
        return DTLootTableProvider.createLeavesDrops(this.seedDropChances, LootParameterSets.field_216267_h);
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(LootTableManager lootTableManager, Species species) {
        return this.lootTableSupplier.get(lootTableManager, species);
    }

    public boolean shouldGenerateDrops() {
        return this.getPrimitiveLeavesBlock().isPresent();
    }

    public LootTable.Builder createDrops() {
        return DTLootTableProvider.createLeavesDrops(this.seedDropChances, DTLootParameterSets.LEAVES);
    }

    public List<ItemStack> getDrops(World world, BlockPos pos, ItemStack tool, Species species) {
        if (world.field_72995_K) {
            return Collections.emptyList();
        }
        return this.getLootTable(world.func_73046_m().func_200249_aQ(), species).func_216113_a(this.createLootContext(world, pos, tool, species));
    }

    private LootContext createLootContext(World world, BlockPos pos, ItemStack tool, Species species) {
        return new LootContext.Builder(WorldContext.getServerWorldOrThrow((IWorld)world)).func_216015_a(LootParameters.field_216287_g, (Object)world.func_180495_p(pos)).func_216015_a(DTLootParameters.SPECIES, (Object)species).func_216015_a(DTLootParameters.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(WorldContext.create((IWorld)world), pos))).func_216015_a(LootParameters.field_216289_i, (Object)tool).func_216022_a(DTLootParameterSets.LEAVES);
    }

    public boolean updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        return this.getDoesAge(false, state);
    }

    public int getRadiusForConnection(BlockState state, IBlockReader blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        int twigRadius = from.getFamily().getPrimaryThickness();
        return (fromRadius == twigRadius || this.connectAnyRadius) && from.getFamily().isCompatibleDynamicLeaves(from.getFamily().getCommonSpecies(), blockAccess.func_180495_p(pos), blockAccess, pos) ? twigRadius : 0;
    }

    public boolean canBeSheared() {
        return this.canBeSheared;
    }

    public void setCanBeSheared(boolean canBeSheared) {
        this.canBeSheared = canBeSheared;
    }

    public List<ITag.INamedTag<Block>> defaultLeavesTags() {
        return Collections.singletonList(DTBlockTags.LEAVES);
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.stateGenerator.get().generate(provider, this);
    }

    public void setColorNumber(Integer colorNumber) {
        this.colorNumber = colorNumber;
    }

    public void setColorString(String colorString) {
        this.colorString = colorString;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int treeFallColorMultiplier(BlockState state, IBlockDisplayReader world, BlockPos pos) {
        return this.foliageColorMultiplier(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int foliageColorMultiplier(BlockState state, IBlockDisplayReader world, BlockPos pos) {
        if (this.colorMultiplier == null) {
            return 0xFF00FF;
        }
        return this.colorMultiplier.getColor(state, world, pos, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processColor() {
        int color = -1;
        if (this.colorNumber != null) {
            color = this.colorNumber;
        } else if (this.colorString != null) {
            String code = this.colorString;
            if (code.startsWith("@")) {
                if ("biome".equals(code = code.substring(1))) {
                    this.colorMultiplier = (state, world, pos, t) -> ((IWorld)world).func_226691_t_(pos).func_225527_a_();
                    return;
                }
                IBlockColor blockColor = BlockColorMultipliers.find(code);
                if (blockColor != null) {
                    this.colorMultiplier = blockColor;
                    return;
                }
                LogManager.getLogger().error("ColorMultiplier resource '{}' could not be found.", (Object)code);
            } else {
                color = Color.decode(code).getRGB();
            }
        }
        int c = color;
        this.colorMultiplier = (s, w, p, t) -> c == -1 ? Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.getPrimitiveLeaves(), w, p, 0) : c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postInitClient() {
        REGISTRY.getAll().forEach(LeavesProperties::processColor);
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"primitiveLeaves", (Object)this.primitiveLeaves), Pair.of((Object)"cellKit", (Object)this.cellKit), Pair.of((Object)"smotherLeavesMax", (Object)this.smotherLeavesMax), Pair.of((Object)"lightRequirement", (Object)this.lightRequirement), Pair.of((Object)"fireSpreadSpeed", (Object)this.fireSpreadSpeed), Pair.of((Object)"flammability", (Object)this.flammability), Pair.of((Object)"connectAnyRadius", (Object)this.connectAnyRadius));
    }

    public static enum AgeingConfiguration {
        ALWAYS(true, true),
        WORLDGEN_ONLY(true, false),
        GROWTH_ONLY(false, true),
        NEVER(false, false);

        private final boolean ageDuringWorldGen;
        private final boolean ageDuringGrowth;

        private AgeingConfiguration(boolean ageDuringWorldGen, boolean ageDuringGrowth) {
            this.ageDuringWorldGen = ageDuringWorldGen;
            this.ageDuringGrowth = ageDuringGrowth;
        }

        public boolean shouldAge(boolean worldGen) {
            if (worldGen) {
                return this.ageDuringWorldGen;
            }
            return this.ageDuringGrowth;
        }
    }
}

