/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks.branches;

import com.ferreusveritas.dynamictrees.blocks.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.Musable;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.Null;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrunkShellBlock
extends BlockWithDynamicHardness
implements IWaterLoggable {
    public static final EnumProperty<CoordUtils.Surround> CORE_DIR = EnumProperty.func_177709_a((String)"coredir", CoordUtils.Surround.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public TrunkShellBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CORE_DIR}).func_206894_a(new Property[]{WATERLOGGED});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        ShellMuse muse = this.getMuseUnchecked((IBlockReader)worldIn, state, pos);
        if (!this.isValid(muse)) {
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            } else {
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return Null.applyIfNonnull(this.getMuse((IBlockReader)world, state, pos), muse -> muse.state.func_177230_c().removedByPlayer(muse.state, world, muse.pos, player, willHarvest, world.func_204610_c(pos)), false);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return Null.applyIfNonnull(this.getMuse(worldIn, state, pos), muse -> Float.valueOf(muse.state.func_177230_c().func_180647_a(muse.state, player, worldIn, muse.pos)), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public float getHardness(BlockState state, IBlockReader world, BlockPos pos) {
        return Null.applyIfNonnull(this.getMuse(world, pos), muse -> Float.valueOf(((BlockWithDynamicHardness)muse.state.func_177230_c()).getHardness(state, world, muse.pos)), Float.valueOf(super.getHardness(state, world, pos))).floatValue();
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return Null.applyIfNonnull(this.getMuse((IBlockReader)world, state, pos), muse -> muse.state.func_177230_c().getSoundType(muse.state, world, muse.pos, entity), SoundType.field_185848_a);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return Null.applyIfNonnull(this.getMuse(world, pos), muse -> Float.valueOf(muse.state.func_177230_c().getExplosionResistance(world.func_180495_p(pos), world, muse.pos, explosion)), Float.valueOf(0.0f)).floatValue();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        BlockPos clickedPos;
        World world = useContext.func_195991_k();
        if (this.museDoesNotExist((IBlockReader)world, state, clickedPos = useContext.func_195995_a())) {
            this.scheduleUpdateTick((IBlockReader)world, clickedPos);
            return false;
        }
        return false;
    }

    public CoordUtils.Surround getMuseDir(BlockState state, BlockPos pos) {
        return (CoordUtils.Surround)((Object)state.func_177229_b(CORE_DIR));
    }

    public boolean museDoesNotExist(IBlockReader world, BlockState state, BlockPos pos) {
        BlockPos musePos = pos.func_177971_a(this.getMuseDir(state, pos).getOffset());
        return CoordUtils.getStateSafe(world, musePos) == null;
    }

    @Nullable
    public ShellMuse getMuseUnchecked(IBlockReader access, BlockPos pos) {
        return this.getMuseUnchecked(access, access.func_180495_p(pos), pos);
    }

    @Nullable
    public ShellMuse getMuseUnchecked(IBlockReader access, BlockState state, BlockPos pos) {
        return this.getMuseUnchecked(access, state, pos, pos);
    }

    @Nullable
    public ShellMuse getMuseUnchecked(IBlockReader access, BlockState state, BlockPos pos, BlockPos originalPos) {
        CoordUtils.Surround museDir = this.getMuseDir(state, pos);
        BlockPos musePos = pos.func_177971_a(museDir.getOffset());
        BlockState museState = CoordUtils.getStateSafe(access, musePos);
        if (museState == null) {
            return null;
        }
        Block block = museState.func_177230_c();
        if (block instanceof Musable && ((Musable)block).isMusable(access, museState, musePos)) {
            return new ShellMuse(museState, musePos, museDir, musePos.func_177973_b((Vector3i)originalPos));
        }
        if (block instanceof TrunkShellBlock) {
            Vector3i offset = ((TrunkShellBlock)block).getMuseDir(museState, musePos).getOffset();
            Vector3d vector3d = new Vector3d((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
            Vector3d vector3d2 = new Vector3d((double)museDir.getOffset().func_177958_n(), (double)museDir.getOffset().func_177956_o(), (double)museDir.getOffset().func_177952_p());
            if (vector3d.func_178787_e(vector3d2).func_189985_c() > 2.25) {
                return ((TrunkShellBlock)block).getMuseUnchecked(access, museState, musePos, originalPos);
            }
        }
        return null;
    }

    @Nullable
    public ShellMuse getMuse(IBlockReader access, BlockPos pos) {
        return this.getMuse(access, access.func_180495_p(pos), pos);
    }

    @Nullable
    public ShellMuse getMuse(IBlockReader access, BlockState state, BlockPos pos) {
        ShellMuse muse = this.getMuseUnchecked(access, state, pos);
        if (!this.isValid(muse)) {
            this.scheduleUpdateTick(access, pos);
        }
        return muse;
    }

    protected boolean isValid(@Nullable ShellMuse muse) {
        return muse != null && muse.getRadius() > 8;
    }

    public void scheduleUpdateTick(IBlockReader access, BlockPos pos) {
        if (!(access instanceof IWorld)) {
            return;
        }
        ((IWorld)access).func_205220_G_().func_205362_a(pos.func_185334_h(), (Object)this, 0, TickPriority.HIGH);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean p_220069_6_) {
        this.scheduleUpdateTick((IBlockReader)world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return Null.applyIfNonnull(this.getMuse(reader, state, pos), muse -> VoxelShapes.func_197881_a((AxisAlignedBB)muse.state.func_196954_c(reader, muse.pos).func_197752_a().func_186670_a(muse.museOffset)), VoxelShapes.func_197880_a());
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return Null.applyIfNonnull(this.getMuse(world, state, pos), muse -> muse.state.func_177230_c().getPickBlock(muse.state, target, world, muse.pos, player), ItemStack.field_190927_a);
    }

    public boolean isAir(BlockState state, IBlockReader access, BlockPos pos) {
        if (this.museDoesNotExist(access, state, pos)) {
            this.scheduleUpdateTick(access, pos);
            return false;
        }
        return false;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        Null.consumeIfNonnull(this.getMuse((IBlockReader)world, state, pos), muse -> muse.state.func_177230_c().onBlockExploded(muse.state, world, muse.pos, explosion));
    }

    @Nullable
    protected CoordUtils.Surround findDetachedMuse(World world, BlockPos pos) {
        for (CoordUtils.Surround s : CoordUtils.Surround.values()) {
            BlockState state = world.func_180495_p(pos.func_177971_a(s.getOffset()));
            if (!(state.func_177230_c() instanceof Musable)) continue;
            return s;
        }
        return null;
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        BlockState newState = world.func_180495_p(pos);
        if (newState.func_177230_c() != Blocks.field_150350_a) {
            return;
        }
        Null.consumeIfNonnull(this.findDetachedMuse((World)world, pos), surround -> world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(CORE_DIR, (Comparable)((Object)surround)), 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        return Null.applyIfNonnull(this.getMuse((IBlockReader)world, state, pos), muse -> muse.state.func_177230_c().func_225533_a_(muse.state, world, muse.pos, playerIn, hand, hit), ActionResultType.FAIL);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 0;
    }

    public boolean isFullBlockShell(IBlockReader world, BlockPos pos) {
        return this.isFullBlockShell(this.getMuse(world, pos));
    }

    public boolean isFullBlockShell(@Nullable ShellMuse muse) {
        return muse != null && this.isFullBlockShell(muse.getRadius());
    }

    public boolean isFullBlockShell(int radius) {
        return (radius - 8) % 16 == 0;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType pathType) {
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.isFullBlockShell(world, pos)) {
            return false;
        }
        return super.func_204510_a(world, pos, state, fluid);
    }

    protected boolean isWaterLogged(BlockState state) {
        return state.func_235901_b_((Property)WATERLOGGED) && (Boolean)state.func_177229_b((Property)WATERLOGGED) != false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        if (state.func_177230_c() == this) {
            ShellMuse muse = this.getMuseUnchecked((IBlockReader)world, state, pos);
            if (muse == null) {
                return true;
            }
            BlockState museState = muse.state;
            BlockPos musePos = muse.pos;
            manager.func_180533_a(musePos, museState);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (!(target instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockPos shellPos = ((BlockRayTraceResult)target).func_216350_a();
        if (state.func_177230_c() == this) {
            ShellMuse muse = this.getMuseUnchecked((IBlockReader)world, state, shellPos);
            if (muse == null) {
                return true;
            }
            BlockState museState = muse.state;
            BlockPos musePos = muse.pos;
            Random rand = world.field_73012_v;
            int x = musePos.func_177958_n();
            int y = musePos.func_177956_o();
            int z = musePos.func_177952_p();
            AxisAlignedBB axisalignedbb = museState.func_196951_e((IBlockReader)world, musePos).func_197752_a();
            double d0 = (double)x + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
            double d1 = (double)y + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
            double d2 = (double)z + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
            switch (((BlockRayTraceResult)target).func_216354_b()) {
                case DOWN: {
                    d1 = (double)y + axisalignedbb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    d1 = (double)y + axisalignedbb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    d2 = (double)z + axisalignedbb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    d2 = (double)z + axisalignedbb.field_72334_f + 0.1;
                    break;
                }
                case WEST: {
                    d0 = (double)x + axisalignedbb.field_72340_a - 0.1;
                    break;
                }
                case EAST: {
                    d0 = (double)x + axisalignedbb.field_72336_d + 0.1;
                }
            }
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, museState), d0, d1, d2, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public static class ShellMuse {
        public final BlockState state;
        public final BlockPos pos;
        public final BlockPos museOffset;
        public final CoordUtils.Surround dir;

        public ShellMuse(BlockState state, BlockPos pos, CoordUtils.Surround dir, BlockPos museOffset) {
            this.state = state;
            this.pos = pos;
            this.dir = dir;
            this.museOffset = museOffset;
        }

        public int getRadius() {
            Block block = this.state.func_177230_c();
            return block instanceof BranchBlock ? ((BranchBlock)block).getRadius(this.state) : 0;
        }
    }
}

