/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.tileentity.PottedSaplingTileEntity;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.ferreusveritas.dynamictrees.util.Null;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PottedSaplingBlock
extends ContainerBlock {
    public static final ResourceLocation REG_NAME = DynamicTrees.resLoc("potted_sapling");
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public PottedSaplingBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_());
    }

    public Species getSpecies(IBlockReader world, BlockPos pos) {
        return Null.applyIfNonnull(this.getTileEntityPottedSapling(world, pos), PottedSaplingTileEntity::getSpecies, Species.NULL_SPECIES);
    }

    public boolean setSpecies(World world, BlockPos pos, BlockState state, Species species) {
        return Null.consumeIfNonnull(this.getTileEntityPottedSapling((IBlockReader)world, pos), pottedSaplingTileEntity -> pottedSaplingTileEntity.setSpecies(species));
    }

    public BlockState getPotState(World world, BlockPos pos) {
        return Null.applyIfNonnull(this.getTileEntityPottedSapling((IBlockReader)world, pos), PottedSaplingTileEntity::getPot, Blocks.field_150457_bL.func_176223_P());
    }

    public boolean setPotState(World world, BlockState potState, BlockPos pos) {
        return Null.consumeIfNonnull(this.getTileEntityPottedSapling((IBlockReader)world, pos), pottedSaplingTileEntity -> pottedSaplingTileEntity.setPot(potState));
    }

    @Nullable
    private PottedSaplingTileEntity getTileEntityPottedSapling(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof PottedSaplingTileEntity ? (PottedSaplingTileEntity)tileEntity : null;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PottedSaplingTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        Species species = this.getSpecies((IBlockReader)world, pos);
        if (!species.isValid()) {
            return ActionResultType.FAIL;
        }
        ItemStack seedStack = species.getSeedStack(1);
        if (heldItem.func_77973_b() == seedStack.func_77973_b() || hand == Hand.OFF_HAND && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == seedStack.func_77973_b()) {
            return ActionResultType.PASS;
        }
        if (heldItem.func_190926_b()) {
            player.func_184611_a(hand, seedStack);
        } else if (!player.func_191521_c(seedStack)) {
            player.func_71019_a(seedStack, false);
        }
        world.func_180501_a(pos, this.getPotState(world, pos), 3);
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Species species;
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)target).func_216354_b() == Direction.UP && (species = this.getSpecies(world, pos)).isValid()) {
            return species.getSeedStack(1);
        }
        BlockState potState = Null.applyIfNonnull(this.getTileEntityPottedSapling(world, pos), PottedSaplingTileEntity::getPot, BlockStates.AIR);
        if (potState.func_177230_c() == Blocks.field_150457_bL) {
            return new ItemStack((IItemProvider)Items.field_222087_nH);
        }
        if (potState.func_177230_c() instanceof FlowerPotBlock) {
            return new ItemStack((IItemProvider)potState.func_177230_c(), 1);
        }
        return new ItemStack((IItemProvider)Items.field_222087_nH);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos, Direction.UP)) {
            this.spawnDrops(world, pos);
            world.func_175656_a(pos, BlockStates.AIR);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        this.spawnDrops(world, pos);
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public void spawnDrops(World world, BlockPos pos) {
        ItemUtils.spawnItemStack(world, pos, new ItemStack((IItemProvider)Blocks.field_150457_bL), false);
        if (this.getSpecies((IBlockReader)world, pos) != Species.NULL_SPECIES) {
            ItemUtils.spawnItemStack(world, pos, this.getSpecies((IBlockReader)world, pos).getSeedStack(1), false);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType pathType) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)FLOWER_POT_AABB);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

