/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.GrowableBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class PodBlock
extends HorizontalBlock
implements GrowableBlock,
IGrowable {
    private final Pod pod;

    public PodBlock(AbstractBlock.Properties properties, Pod pod) {
        super(properties);
        this.pod = pod;
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.field_176227_L = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
        if (this.pod != null) {
            builder.func_206894_a(new Property[]{this.pod.getAgeProperty()});
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.pod.getBlockShape(this.getFacing(state), this.getAge(state));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.doTick(state, (World)world, pos, random);
    }

    public void doTick(BlockState state, World world, BlockPos pos, Random random) {
        if (!this.isSupported((IBlockReader)world, pos, state)) {
            this.drop((IWorld)world, pos, state);
            return;
        }
        int age = this.getAge(state);
        Float season = SeasonHelper.getSeasonValue((IWorld)world, pos);
        if (season != null) {
            if (this.pod.isOutOfSeason(WorldContext.create((IWorld)world), pos)) {
                this.outOfSeason(world, pos);
                return;
            }
            if (age == 0 && this.pod.isInFlowerHoldPeriod((IWorld)world, pos, season)) {
                return;
            }
        }
        if (age < this.pod.getMaxAge()) {
            this.tryGrow(state, world, pos, random, age, season);
        } else {
            this.tickMature(world, pos, state);
        }
    }

    private void outOfSeason(World world, BlockPos pos) {
        world.func_175655_b(pos, false);
    }

    private void tryGrow(BlockState state, World world, BlockPos pos, Random random, int age, @Nullable Float season) {
        boolean doGrow = random.nextFloat() < this.getGrowthChance(world, pos);
        boolean eventGrow = ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (boolean)doGrow);
        if (season != null ? doGrow || eventGrow : eventGrow) {
            this.setAge(world, pos, state, age + 1);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    private float getGrowthChance(World world, BlockPos pos) {
        return this.pod.getGrowthChance();
    }

    public void tickMature(World world, BlockPos pos, BlockState state) {
        this.pod.performMatureAction(new GrowableBlock.Info((IWorld)world, pos, state));
    }

    @Override
    public void performMatureAction(IWorld world, BlockPos pos, BlockState state) {
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isSupported((IBlockReader)world, pos, state)) {
            this.drop((IWorld)world, pos, state);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return this.isSupported((IBlockReader)world, pos, state);
    }

    @Override
    public boolean isSupported(IBlockReader world, BlockPos pos, BlockState state) {
        BlockState branchState = world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)));
        BranchBlock branch = TreeHelper.getBranch(branchState);
        return branch != null && branch.getRadius(branchState) == 8;
    }

    public List<ItemStack> func_220076_a(BlockState pState, LootContext.Builder pBuilder) {
        ResourceLocation resourcelocation = this.func_220068_i();
        if (resourcelocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootcontext = pBuilder.func_216015_a(LootParameters.field_216287_g, (Object)pState).func_216022_a(LootParameterSets.field_216267_h);
        LootTable loottable = lootcontext.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        if (loottable == LootTable.field_186464_a && pState.func_235901_b_((Property)this.pod.getAgeProperty()) && ((Integer)pState.func_177229_b((Property)this.pod.getAgeProperty())).intValue() == this.pod.getMaxAge()) {
            return Collections.singletonList(this.pod.getItemStack());
        }
        return loottable.func_216113_a(lootcontext);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.pod.getItemStack();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.getAge(state) >= this.pod.getMaxAge()) {
            this.drop((IWorld)world, pos, state);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.pod.canBoneMeal() && this.getAge(state) < this.pod.getMaxAge();
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        int newAge = Math.min(age + 1, this.pod.getMaxAge());
        if (newAge != age) {
            this.setAge((World)world, pos, state, newAge);
        }
    }

    private Direction getFacing(BlockState state) {
        return (Direction)state.func_177229_b((Property)field_185512_D);
    }

    public int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.pod.getAgeProperty());
    }

    public float getAgeAsPercentage(BlockState state) {
        return (float)this.getAge(state) * 100.0f / (float)this.getMaxAge();
    }

    public int getMaxAge() {
        return this.pod.getMaxAge();
    }

    private void setAge(World world, BlockPos pos, BlockState state, int newAge) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)this.pod.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)this.pod.getAgeProperty(), (Comparable)Integer.valueOf(0));
        BlockPos pos = context.func_195995_a();
        for (Direction direction : context.func_196009_e()) {
            if (!direction.func_176740_k().func_176722_c() || !(state = (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)direction)).func_196955_c((IWorldReader)context.func_195991_k(), pos)) continue;
            return state;
        }
        return null;
    }

    public boolean func_196266_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, PathType pType) {
        return false;
    }
}

