/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public interface GrowableBlock {
    public void performMatureAction(IWorld var1, BlockPos var2, BlockState var3);

    default public void drop(IWorld world, BlockPos pos, BlockState state) {
        world.func_175655_b(pos, true);
    }

    default public void rot(IWorld world, BlockPos pos, BlockState state) {
        world.func_175655_b(pos, false);
    }

    public boolean isSupported(IBlockReader var1, BlockPos var2, BlockState var3);

    public static enum MatureAction {
        DEFAULT((block, info) -> block.performMatureAction(((Info)info).world, ((Info)info).pos, ((Info)info).state)),
        DROP((block, info) -> block.drop(((Info)info).world, ((Info)info).pos, ((Info)info).state)),
        ROT((block, info) -> block.rot(((Info)info).world, ((Info)info).pos, ((Info)info).state));

        private final BiConsumer<GrowableBlock, Info> action;

        private MatureAction(BiConsumer<GrowableBlock, Info> action) {
            this.action = action;
        }

        public void perform(GrowableBlock block, Info blockInfo) {
            this.action.accept(block, blockInfo);
        }
    }

    public static class Info {
        private final IWorld world;
        private final BlockPos pos;
        private final BlockState state;

        public Info(IWorld world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }
    }
}

