/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class DynamicSaplingBlock
extends Block
implements IGrowable,
IPlantable {
    protected Species species;

    public DynamicSaplingBlock(Species species) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200944_c().func_226896_b_());
        this.species = species;
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return this.getSpecies().canSaplingConsumeBoneMeal((World)world, pos);
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.getSpecies().canSaplingGrowAfterBoneMeal(world, rand, pos);
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getSpecies().saplingFireSpread();
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getSpecies().saplingFlammability();
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (this.getSpecies().canSaplingGrowNaturally((World)worldIn, pos)) {
            this.func_225535_a_(worldIn, rand, pos, state);
        }
    }

    public static boolean canSaplingStay(IWorldReader world, Species species, BlockPos pos) {
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockState blockState = world.func_180495_p(pos.func_177972_a(dir));
            Block block = blockState.func_177230_c();
            if (!TreeHelper.isBranch(block) && !(block instanceof DynamicSaplingBlock)) continue;
            return false;
        }
        return world.func_175623_d(pos.func_177984_a()) && species.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return DynamicSaplingBlock.canSaplingStay(world, this.getSpecies(), pos);
    }

    public void func_225535_a_(@Nonnull ServerWorld world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (this.func_196260_a(state, (IWorldReader)world, pos)) {
            Species species = this.getSpecies();
            if (species.canSaplingGrow((World)world, pos)) {
                species.transitionToTree((World)world, pos);
            }
        } else {
            this.dropBlock((World)world, state, pos);
        }
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getSpecies().getSaplingSound();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            this.dropBlock(world, state, pos);
        }
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    protected void dropBlock(World world, BlockState state, BlockPos pos) {
        world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.getSpecies().getSeedStack(1)));
        world.func_217377_a(pos, false);
    }

    @Nonnull
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return this.getSpecies().getSeedStack(1);
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        if (builder.func_216018_a().func_73046_m().func_200249_aQ().func_215304_a().contains(this.func_220068_i())) {
            return super.func_220076_a(state, builder);
        }
        return (Boolean)DTConfigs.DYNAMIC_SAPLING_DROPS.get() != false ? Collections.singletonList(this.getSpecies().getSeedStack(1)) : Collections.emptyList();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getSpecies().getSeedStack(1);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader access, BlockPos pos, ISelectionContext context) {
        return this.getSpecies().getSaplingShape();
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

