/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.GenerationStage;

public class BiomePropertySelectors {

    public static enum Chance {
        OK,
        CANCEL,
        UNHANDLED;

    }

    public static class RandomSpeciesSelector
    implements SpeciesSelector {
        ArrayList<Entry> decisionTable = new ArrayList();
        int totalWeight;

        public int getSize() {
            return this.decisionTable.size();
        }

        public RandomSpeciesSelector add(@Nonnull Species species, int weight) {
            this.decisionTable.add(new Entry(new SpeciesSelection(species), weight));
            this.totalWeight += weight;
            return this;
        }

        public RandomSpeciesSelector add(int weight) {
            this.decisionTable.add(new Entry(new SpeciesSelection(), weight));
            this.totalWeight += weight;
            return this;
        }

        @Override
        public SpeciesSelection getSpecies(BlockPos pos, BlockState dirt, Random random) {
            int chance = random.nextInt(this.totalWeight);
            for (Entry entry : this.decisionTable) {
                if (chance < entry.weight) {
                    return entry.decision;
                }
                chance -= entry.weight;
            }
            return this.decisionTable.get((int)(this.decisionTable.size() - 1)).decision;
        }

        private class Entry {
            public SpeciesSelection decision;
            public int weight;

            public Entry(SpeciesSelection d, int w) {
                this.decision = d;
                this.weight = w;
            }
        }
    }

    public static class StaticSpeciesSelector
    implements SpeciesSelector {
        final SpeciesSelection decision;

        public StaticSpeciesSelector(SpeciesSelection decision) {
            this.decision = decision;
        }

        public StaticSpeciesSelector(@Nonnull Species species) {
            this(new SpeciesSelection(species));
        }

        public StaticSpeciesSelector() {
            this(new SpeciesSelection());
        }

        @Override
        public SpeciesSelection getSpecies(BlockPos pos, BlockState dirt, Random random) {
            return this.decision;
        }
    }

    public static class SpeciesSelection {
        private final boolean handled;
        private final Species species;

        public SpeciesSelection() {
            this.handled = false;
            this.species = Species.NULL_SPECIES;
        }

        public SpeciesSelection(@Nonnull Species species) {
            this.species = species;
            this.handled = true;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public Species getSpecies() {
            return this.species;
        }
    }

    public static final class FeatureCancellations {
        private final Collection<String> namespaces = Sets.newHashSet();
        private final Collection<FeatureCanceller> featureCancellers = Sets.newHashSet();
        private final Collection<GenerationStage.Decoration> stages = Sets.newHashSet();

        public void putNamespace(String namespace) {
            this.namespaces.add(namespace);
        }

        public boolean shouldCancelNamespace(String namespace) {
            return this.namespaces.contains(namespace);
        }

        public void putCanceller(FeatureCanceller featureCanceller) {
            this.featureCancellers.add(featureCanceller);
        }

        public void putStage(GenerationStage.Decoration stage) {
            this.stages.add(stage);
        }

        public void putDefaultStagesIfEmpty() {
            if (this.stages.size() < 1) {
                this.stages.add(GenerationStage.Decoration.VEGETAL_DECORATION);
            }
        }

        public void addAllFrom(FeatureCancellations featureCancellations) {
            this.namespaces.addAll(featureCancellations.namespaces);
            this.featureCancellers.addAll(featureCancellations.featureCancellers);
            this.stages.addAll(featureCancellations.stages);
        }

        public void reset() {
            this.namespaces.clear();
            this.featureCancellers.clear();
            this.stages.clear();
        }

        public Collection<FeatureCanceller> getFeatureCancellers() {
            return this.featureCancellers;
        }

        public Collection<GenerationStage.Decoration> getStages() {
            return this.stages;
        }
    }

    @FunctionalInterface
    public static interface SpeciesSelector {
        public SpeciesSelection getSpecies(BlockPos var1, BlockState var2, Random var3);
    }

    @FunctionalInterface
    public static interface DensitySelector {
        public double getDensity(Random var1, double var2);
    }

    @FunctionalInterface
    public static interface ChanceSelector {
        public Chance getChance(Random var1, @Nonnull Species var2, int var3);
    }
}

