/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource.loading.preparation;

import com.ferreusveritas.dynamictrees.api.resource.Resource;
import com.ferreusveritas.dynamictrees.api.resource.ResourceCollector;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.AbstractResourcePreparer;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.PreparationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class JsonResourcePreparer
extends AbstractResourcePreparer<JsonElement> {
    private static final String JSON_EXTENSION = ".json";

    public JsonResourcePreparer(String folderName) {
        this(folderName, ResourceCollector.ordered());
    }

    public JsonResourcePreparer(String folderName, ResourceCollector<JsonElement> resourceCollector) {
        super(folderName, JSON_EXTENSION, resourceCollector);
    }

    @Override
    protected void readAndPutResource(IResource resource, ResourceLocation resourceName) throws PreparationException {
        JsonElement jsonElement = JsonResourcePreparer.readResource(resource);
        this.resourceCollector.put(new Resource<JsonElement>(resourceName, jsonElement));
    }

    @Nonnull
    static JsonElement readResource(IResource resource) throws PreparationException {
        BufferedReader reader = JsonResourcePreparer.getReader(resource);
        JsonElement json = JsonResourcePreparer.tryParseJson(reader);
        if (json == null) {
            throw new PreparationException("Couldn't load file as it's null or empty");
        }
        return json;
    }

    private static BufferedReader getReader(IResource resource) {
        return new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
    }

    @Nullable
    private static JsonElement tryParseJson(Reader reader) throws PreparationException {
        try {
            return (JsonElement)JSONUtils.func_193839_a((Gson)JsonHelper.getGson(), (Reader)reader, JsonElement.class);
        }
        catch (JsonParseException e) {
            throw new PreparationException(e);
        }
    }
}

