/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource.loading.preparation;

import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.ResourceCollector;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.PreparationException;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.ResourcePreparer;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;

public abstract class AbstractResourcePreparer<R>
implements ResourcePreparer<R> {
    private final String folderName;
    private final String extension;
    private final int extensionLength;
    protected final ResourceCollector<R> resourceCollector;

    public AbstractResourcePreparer(String folderName, String extension, ResourceCollector<R> resourceCollector) {
        this.folderName = folderName;
        this.extension = extension;
        this.extensionLength = extension.length();
        this.resourceCollector = resourceCollector;
    }

    @Override
    public ResourceAccessor<R> prepare(IResourceManager resourceManager) {
        this.readAndPutResources(this.collectResources(resourceManager), resourceManager);
        ResourceAccessor<R> accessor = this.resourceCollector.createAccessor();
        this.resourceCollector.clear();
        return accessor;
    }

    protected Collection<ResourceLocation> collectResources(IResourceManager resourceManager) {
        return resourceManager.func_199003_a(this.folderName, fileName -> fileName.endsWith(this.extension));
    }

    protected void readAndPutResources(Collection<ResourceLocation> resourceLocations, IResourceManager resourceManager) {
        resourceLocations.forEach(location -> {
            ResourceLocation resourceName = this.getResourceName((ResourceLocation)location);
            this.tryReadAndPutResource(resourceManager, (ResourceLocation)location, resourceName);
        });
    }

    private void tryReadAndPutResource(IResourceManager resourceManager, ResourceLocation location, ResourceLocation resourceName) {
        try {
            this.readAndPutResource(resourceManager.func_199002_a(location), resourceName);
        }
        catch (PreparationException | IOException e) {
            this.logError(location, e);
        }
    }

    protected abstract void readAndPutResource(IResource var1, ResourceLocation var2) throws PreparationException, IOException;

    protected void logError(ResourceLocation location, Exception e) {
        LogManager.getLogger().error("Could not read file \"" + location + "\" due to exception.", (Throwable)e);
    }

    protected ResourceLocation getResourceName(ResourceLocation location) {
        String resourcePath = location.func_110623_a();
        int pathIndex = this.folderName.length() + 1;
        int pathEndIndex = resourcePath.length() - this.extensionLength;
        return new ResourceLocation(location.func_110624_b(), resourcePath.substring(pathIndex, pathEndIndex));
    }
}

