/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource;

import com.ferreusveritas.dynamictrees.api.resource.Resource;
import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

final class SimpleResourceAccessor<R>
implements ResourceAccessor<R> {
    private final Map<ResourceLocation, Resource<R>> resources;
    private final Supplier<Map> mapSupplier;

    public SimpleResourceAccessor(Map<ResourceLocation, Resource<R>> resources, Supplier<Map> mapSupplier) {
        this.resources = resources;
        this.mapSupplier = mapSupplier;
    }

    @Override
    public Resource<R> getResource(ResourceLocation key) {
        return this.resources.get(key);
    }

    @Override
    public Iterable<Resource<R>> getAllResources() {
        return new ArrayList<Resource<R>>(this.resources.values());
    }

    @Override
    public Iterable<Resource<R>> getAllResources(Predicate<ResourceLocation> resourceFilter) {
        return this.resources.entrySet().stream().filter(resource -> resourceFilter.test((ResourceLocation)resource.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public void forEach(Consumer<Resource<R>> resourceConsumer) {
        this.getAllResources().forEach(resourceConsumer);
    }

    @Override
    public ResourceAccessor<R> filtered(Predicate<ResourceLocation> resourceFilter) {
        Map<ResourceLocation, Resource<R>> resources = this.cloneResources();
        this.filterMap(resourceFilter, resources);
        return new SimpleResourceAccessor<R>(resources, this.mapSupplier);
    }

    @Override
    public <N> ResourceAccessor<N> map(Function<R, N> resourceMapper) {
        Map mappedResources = this.freshMap();
        this.resources.forEach((? super K location, ? super V resource) -> mappedResources.put((ResourceLocation)location, new Resource((ResourceLocation)location, resourceMapper.apply(resource.getResource()))));
        return new SimpleResourceAccessor<R>(mappedResources, this.mapSupplier);
    }

    private Map<ResourceLocation, Resource<R>> cloneResources() {
        Map<ResourceLocation, Resource<R>> resources = this.freshMap();
        resources.putAll(this.resources);
        return resources;
    }

    private <N> Map<ResourceLocation, Resource<N>> freshMap() {
        return this.mapSupplier.get();
    }

    private void filterMap(Predicate<ResourceLocation> resourceFilter, Map<ResourceLocation, Resource<R>> newMap) {
        for (ResourceLocation location : this.resources.keySet()) {
            if (resourceFilter.test(location)) continue;
            newMap.remove(location);
        }
    }
}

