/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RegistryEntry<T extends RegistryEntry<T>> {
    private ResourceLocation registryName;
    private boolean valid = true;
    private boolean generateData;

    protected RegistryEntry() {
    }

    protected RegistryEntry(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    protected T nullEntry() {
        this.valid = false;
        return (T)this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public final boolean ifValid(Consumer<T> consumer) {
        if (this.isValid()) {
            consumer.accept(this);
            return true;
        }
        return false;
    }

    public final boolean ifValidElse(Consumer<T> consumer, Runnable runnable) {
        if (this.isValid()) {
            consumer.accept(this);
            return true;
        }
        runnable.run();
        return false;
    }

    public final T elseIfInvalid(T otherValue) {
        return (T)(this.isValid() ? this : otherValue);
    }

    public final boolean ifInvalid(Runnable runnable) {
        if (!this.isValid()) {
            runnable.run();
            return true;
        }
        return false;
    }

    public boolean shouldGenerateData() {
        return this.generateData;
    }

    public void setGenerateData(boolean generateData) {
        this.generateData = generateData;
    }

    public void generateStateData(DTBlockStateProvider provider) {
    }

    public void generateItemModelData(DTItemModelProvider provider) {
    }

    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ITextComponent getTextComponent() {
        return this.formatComponent((ITextComponent)new StringTextComponent(this.getRegistryName().toString()), TextFormatting.AQUA);
    }

    protected ITextComponent formatComponent(ITextComponent component, TextFormatting colour) {
        return component.func_230532_e_().func_240700_a_(style -> style.func_240712_a_(colour).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.registry_name", new Object[]{this.getRegistryName()}))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.getRegistryName().toString())));
    }

    public final T setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{registryName=" + this.getRegistryName() + "}";
    }

    public String toLoadDataString() {
        return this.toString();
    }

    public String toReloadDataString() {
        return this.toString();
    }

    @SafeVarargs
    public final String getString(Pair<String, Object> ... propertyPairs) {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName() + "{registryName=" + this.getRegistryName() + ", ");
        for (int i = 0; i < propertyPairs.length; ++i) {
            Pair<String, Object> currentProperty = propertyPairs[i];
            stringBuilder.append((String)currentProperty.getKey()).append("=").append(currentProperty.getValue()).append(i != propertyPairs.length - 1 ? ", " : "}");
        }
        return stringBuilder.toString();
    }
}

