/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.blocks.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class SaplingStateGenerator
implements Generator<DTBlockStateProvider, Species> {
    public static final Generator.DependencyKey<DynamicSaplingBlock> SAPLING = new Generator.DependencyKey("sapling");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LOG = new Generator.DependencyKey("primitive_log");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LEAVES = new Generator.DependencyKey("primitive_leaves", true);

    @Override
    public void generate(DTBlockStateProvider provider, Species input, Generator.Dependencies dependencies) {
        Optional<ResourceLocation> leavesTextureLocation = dependencies.getOptional(PRIMITIVE_LEAVES).map(primitiveLeaves -> provider.block(Objects.requireNonNull(primitiveLeaves.getRegistryName())));
        ResourceLocation primitiveLogLocation = Objects.requireNonNull(dependencies.get(PRIMITIVE_LOG).getRegistryName());
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/saplings/" + input.getRegistryName().func_110623_a())).parent((ModelFile)provider.models().getExistingFile(input.getSaplingSmartModelLocation()));
        input.addSaplingTextures((arg_0, arg_1) -> ((BlockModelBuilder)builder).texture(arg_0, arg_1), leavesTextureLocation.orElse(primitiveLogLocation), provider.block(primitiveLogLocation));
        provider.simpleBlock(dependencies.get(SAPLING), (ModelFile)builder);
    }

    @Override
    public Generator.Dependencies gatherDependencies(Species input) {
        return new Generator.Dependencies().append(SAPLING, input.getSapling()).append(PRIMITIVE_LOG, input.getFamily().getPrimitiveLog()).append(PRIMITIVE_LEAVES, input.getPrimitiveLeaves());
    }
}

