/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.configurations;

import com.ferreusveritas.dynamictrees.api.configurations.Configurable;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.configurations.Properties;
import com.ferreusveritas.dynamictrees.api.configurations.PropertiesAccessor;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;

public abstract class Configuration<T extends Configuration<T, C>, C extends Configurable>
extends RegistryEntry<T> {
    protected final C configurable;
    protected final Properties properties = new Properties();

    public Configuration(C configurable) {
        this.configurable = configurable;
    }

    public <V> T with(ConfigurationProperty<V> property, V value) {
        if (!this.configurable.isPropertyRegistered(property)) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)new IllegalArgumentException(), (String)("Tried to add unregistered property with identifier '" + property.getKey() + "' and type '" + property.getType() + "' configurable '" + this.configurable + "'."));
            crashReport.func_85058_a("Adding property to a gen feature.");
            throw new ReportedException(crashReport);
        }
        this.properties.put(property, value);
        return (T)this;
    }

    public T withAll(PropertiesAccessor properties) {
        properties.forEach(this::with);
        return (T)this;
    }

    public boolean has(ConfigurationProperty<?> property) {
        return this.properties.has(property);
    }

    @Nonnull
    public <V> V get(ConfigurationProperty<V> property) {
        Optional<V> optionalProperty = this.getAsOptional(property);
        if (optionalProperty.isPresent()) {
            return optionalProperty.get();
        }
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)new IllegalStateException(), (String)("Property '" + property.getKey() + "' from '" + this.configurable + "' is Null."));
        crashReport.func_85058_a("Getting property from a configuration");
        throw new ReportedException(crashReport);
    }

    public <V> Optional<V> getAsOptional(ConfigurationProperty<V> property) {
        if (!this.has(property)) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)new IllegalStateException(), (String)("Tried to obtain property '" + property.getKey() + "' from '" + this.configurable + "' that did not exist."));
            crashReport.func_85058_a("Getting property from a configuration");
            throw new ReportedException(crashReport);
        }
        return Optional.ofNullable(this.properties.get(property));
    }

    public <V> V getOrInvalidDefault(ConfigurationProperty<V> property, Predicate<V> validator, V invalidDefault) {
        return this.getAsOptional(property).filter(validator).orElse(invalidDefault);
    }

    public abstract T copy();

    public C getConfigurable() {
        return this.configurable;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{configurable=" + this.configurable + ", properties=" + this.properties + '}';
    }
}

