/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.configurations;

import com.ferreusveritas.dynamictrees.api.configurations.Configurable;
import com.ferreusveritas.dynamictrees.api.configurations.Configuration;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public abstract class ConfigurableRegistryEntry<T extends ConfigurableRegistryEntry<T, C>, C extends Configuration<C, T>>
extends RegistryEntry<T>
implements Configurable {
    protected final C defaultConfiguration;
    private final Set<ConfigurationProperty<?>> properties = Sets.newHashSet();

    protected ConfigurableRegistryEntry() {
        this.defaultConfiguration = this.createDefaultConfiguration();
    }

    protected ConfigurableRegistryEntry(ResourceLocation registryName) {
        super(registryName);
        this.registerProperties();
        this.defaultConfiguration = (Configuration)((RegistryEntry)this.createDefaultConfiguration()).setRegistryName(registryName);
    }

    protected abstract C createDefaultConfiguration();

    protected abstract void registerProperties();

    protected final T register(ConfigurationProperty<?> ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return (T)this;
    }

    @Override
    public boolean isPropertyRegistered(@Nonnull ConfigurationProperty<?> property) {
        return this.properties.contains(property);
    }

    @Override
    public Set<ConfigurationProperty<?>> getRegisteredProperties() {
        return Collections.unmodifiableSet(this.properties);
    }

    public C getDefaultConfiguration() {
        return (C)((Configuration)this.defaultConfiguration).copy();
    }

    public <V> C with(ConfigurationProperty<V> property, V value) {
        return (C)((Configuration)this.getDefaultConfiguration()).with(property, value);
    }
}

