/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockTagsProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemTagsProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import java.util.Arrays;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public final class GatherDataHelper {
    public static void gatherAllData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        GatherDataHelper.gatherTagData(modId, event);
        GatherDataHelper.gatherBlockStateAndModelData(modId, event, registries);
        GatherDataHelper.gatherItemModelData(modId, event, registries);
        GatherDataHelper.gatherLootData(modId, event);
    }

    public static void gatherTagData(String modId, GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        DTBlockTagsProvider blockTagsProvider = new DTBlockTagsProvider(generator, modId, event.getExistingFileHelper());
        DTItemTagsProvider itemTagsProvider = new DTItemTagsProvider(generator, modId, blockTagsProvider, event.getExistingFileHelper());
        generator.func_200390_a((IDataProvider)blockTagsProvider);
        generator.func_200390_a((IDataProvider)itemTagsProvider);
    }

    public static void gatherBlockStateAndModelData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        event.getGenerator().func_200390_a((IDataProvider)new DTBlockStateProvider(event.getGenerator(), modId, event.getExistingFileHelper(), Arrays.asList(registries)));
    }

    public static void gatherItemModelData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        event.getGenerator().func_200390_a((IDataProvider)new DTItemModelProvider(event.getGenerator(), modId, event.getExistingFileHelper(), Arrays.asList(registries)));
    }

    public static void gatherLootData(String modId, GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new DTLootTableProvider(event.getGenerator(), modId, event.getExistingFileHelper()));
    }
}

