/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.programmer.network;

import java.util.function.Supplier;
import mcjty.rftoolscontrol.modules.programmer.blocks.ProgrammerTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class PacketUpdateNBTItemInventoryProgrammer {
    private BlockPos pos;
    private int slotIndex;
    private CompoundNBT tagCompound;

    public PacketUpdateNBTItemInventoryProgrammer(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.slotIndex = buf.readInt();
        this.tagCompound = buf.func_150793_b();
    }

    public PacketUpdateNBTItemInventoryProgrammer(BlockPos pos, int slotIndex, CompoundNBT tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    protected boolean isValidBlock(World world, BlockPos blockPos, TileEntity tileEntity) {
        return tileEntity instanceof ProgrammerTileEntity;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.slotIndex);
        buf.func_150786_a(this.tagCompound);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            TileEntity te = world.func_175625_s(this.pos);
            if (te != null) {
                if (!this.isValidBlock(world, this.pos, te)) {
                    return;
                }
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                    ItemStack stack = h.getStackInSlot(this.slotIndex);
                    if (!stack.func_190926_b()) {
                        stack.func_77982_d(this.tagCompound);
                    }
                    te.func_70296_d();
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

