/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.crop.ICropGetter;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MysticalSeedsItem
extends BlockNamedItem
implements ICropGetter,
IEnableable {
    private final ICrop crop;

    public MysticalSeedsItem(ICrop crop, Function<Item.Properties, Item.Properties> properties) {
        super((Block)crop.getCrop(), properties.apply(new Item.Properties()));
        this.crop = crop;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled()) {
            super.func_150895_a(group, items);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return Localizable.of((String)"item.mysticalagriculture.mystical_seeds").args(new Object[]{this.crop.getDisplayName()}).build();
    }

    public ITextComponent func_200296_o() {
        return this.func_200295_i(ItemStack.field_190927_a);
    }

    public String func_77658_a() {
        return Localizable.of((String)"item.mysticalagriculture.mystical_seeds").args(new Object[]{this.crop.getDisplayName()}).buildString();
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.crop.hasEffect(stack) || super.func_77636_d(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Set<ResourceLocation> biomes;
        IFormattableTextComponent tier = this.crop.getTier().getDisplayName();
        tooltip.add((ITextComponent)ModTooltips.TIER.args(new Object[]{tier}).build());
        if (!this.crop.getModId().equals("mysticalagriculture")) {
            tooltip.add(ModTooltips.getAddedByTooltip(this.crop.getModId()));
        }
        if (!(biomes = this.crop.getRequiredBiomes()).isEmpty()) {
            tooltip.add((ITextComponent)ModTooltips.REQUIRED_BIOMES.build());
            List ids = biomes.stream().map(ResourceLocation::toString).map(s -> " - " + s).map(StringTextComponent::new).collect(Collectors.toList());
            tooltip.addAll(ids);
        }
        if (flag.func_194127_a()) {
            tooltip.add((ITextComponent)ModTooltips.CROP_ID.args(new Object[]{this.crop.getId()}).color(TextFormatting.DARK_GRAY).build());
        }
    }

    @Override
    public ICrop getCrop() {
        return this.crop;
    }

    public boolean isEnabled() {
        return this.crop.isEnabled();
    }
}

