/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DynamicRecipeManager
implements IResourceManagerReloadListener {
    public void func_195410_a(IResourceManager resourceManager) {
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            ISpecialRecipe seed = this.makeSeedRecipe((ICrop)crop);
            IRecipe<?> seed2 = this.makeRegularSeedRecipe((ICrop)crop);
            ISpecialRecipe reprocessor = this.makeReprocessorRecipe((ICrop)crop);
            if (seed != null) {
                RecipeHelper.addRecipe((IRecipe)seed);
            }
            if (seed2 != null) {
                RecipeHelper.addRecipe(seed2);
            }
            if (reprocessor != null) {
                RecipeHelper.addRecipe((IRecipe)reprocessor);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
    }

    private ISpecialRecipe makeSeedRecipe(ICrop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedInfusionRecipeEnabled()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient essence = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{essenceItem});
        Ingredient craftingSeed = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{craftingSeedItem});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{craftingSeed, material, essence, material, essence, material, essence, material, essence});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_infusion"));
        ItemStack output = new ItemStack((IItemProvider)crop.getSeeds());
        return new InfusionRecipe(name, (NonNullList<Ingredient>)inputs, output);
    }

    private IRecipe<?> makeRegularSeedRecipe(ICrop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedCraftingRecipeEnabled()) {
            return null;
        }
        if (!((Boolean)ModConfigs.SEED_CRAFTING_RECIPES.get()).booleanValue()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient essence = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{essenceItem});
        Ingredient craftingSeed = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{craftingSeedItem});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{material, essence, material, essence, craftingSeed, essence, material, essence, material});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_vanilla"));
        ItemStack output = new ItemStack((IItemProvider)crop.getSeeds());
        return new ShapedRecipe(name, "", 3, 3, inputs, output);
    }

    private ISpecialRecipe makeReprocessorRecipe(ICrop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedReprocessorRecipeEnabled()) {
            return null;
        }
        Ingredient input = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{crop.getSeeds()});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_reprocessor"));
        ItemStack output = new ItemStack((IItemProvider)crop.getEssence(), 2);
        return new ReprocessorRecipe(name, input, output);
    }
}

