/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.setup;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionManager;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.features.RFTFeature;
import mcjty.rftoolsdim.dimension.power.PowerHandler;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import mcjty.rftoolsdim.modules.blob.tools.Spawner;
import mcjty.rftoolsdim.modules.dimlets.DimletConfig;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.network.PacketSendDimletPackages;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ForgeEventHandlers {
    private final Random random = new Random();
    private final PowerHandler powerHandler = new PowerHandler();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        event.getGeneration().getFeatures(GenerationStage.Decoration.RAW_GENERATION).add(() -> RFTFeature.RFTFEATURE_CONFIGURED);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K) {
            this.handleSpawning(event);
            if (event.world.func_234923_W_() == World.field_234918_g_) {
                this.powerHandler.handlePower(event.world);
            }
        }
    }

    private void handleSpawning(TickEvent.WorldTickEvent event) {
        if ("rftoolsdim".equals(event.world.func_234923_W_().func_240901_a_().func_110624_b()) && this.random.nextInt(20) == 10) {
            long count;
            ServerWorld serverWorld = (ServerWorld)event.world;
            CompiledDescriptor compiledDescriptor = DimensionManager.get().getCompiledDescriptor((World)serverWorld);
            DimensionData data = PersistantDimensionManager.get((World)serverWorld).getData(serverWorld.func_234923_W_().func_240901_a_());
            if (!compiledDescriptor.getAttributeTypes().contains((Object)AttributeType.NOBLOBS) && (count = serverWorld.getEntities().filter(s -> s instanceof DimensionalBlobEntity).count()) < 20L) {
                for (ServerPlayerEntity player : serverWorld.func_217369_A()) {
                    for (int i = 0; i < 5; ++i) {
                        Spawner.spawnOne(serverWorld, (PlayerEntity)player, compiledDescriptor, data, this.random);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(FMLServerStartedEvent event) {
        RFToolsDim.setup.getLogger().info("Reading dimlet packages: ");
        DimletDictionary.get().reset();
        for (String file : (List)DimletConfig.DIMLET_PACKAGES.get()) {
            DimletDictionary.get().readPackage(file);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        RFToolsDim.setup.getLogger().info("Client logged in: sending dimlet packages");
        HashMap<DimletKey, DimletSettings> collected = new HashMap<DimletKey, DimletSettings>();
        DimletDictionary dictionary = DimletDictionary.get();
        for (DimletKey key : dictionary.getDimlets()) {
            collected.put(key, dictionary.getSettings(key));
            if (collected.size() < 100) continue;
            RFToolsDimMessages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSendDimletPackages(collected));
            collected.clear();
        }
        if (!collected.isEmpty()) {
            RFToolsDimMessages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSendDimletPackages(collected));
        }
    }
}

