/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsdim.modules.dimlets.client.DimletClientHelper;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import mcjty.rftoolsdim.modules.workbench.blocks.WorkbenchTileEntity;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiWorkbench
extends GenericGuiContainer<WorkbenchTileEntity, GenericContainer> {
    public static final int WIDTH = 256;
    public static final int HEIGHT = 240;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsdim", "textures/gui/dimletworkbench.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private TextField searchBar;
    private WidgetList itemList;
    private ToggleButton allFilter;
    private long dimletListAge = -1L;
    private static String[] pattern = null;

    public GuiWorkbench(WorkbenchTileEntity tileEntity, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)tileEntity, (Container)container, inventory, ((BaseBlock)WorkbenchModule.WORKBENCH.get()).getManualEntry());
        this.field_146999_f = 256;
        this.field_147000_g = 240;
        pattern = null;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.searchBar = Widgets.textfield((int)122, (int)6, (int)123, (int)14).event(this::search);
        this.itemList = ((WidgetList)Widgets.list((int)122, (int)22, (int)120, (int)132).name("widgets")).event(new SelectionEvent(){

            public void select(int index) {
                GuiWorkbench.this.hilightPattern();
            }

            public void doubleClick(int index) {
                if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && Screen.func_231173_s_()) {
                    GuiWorkbench.this.cheatDimlet();
                } else {
                    GuiWorkbench.this.suggestParts();
                }
            }
        });
        Slider slider = Widgets.slider((int)243, (int)22, (int)8, (int)132).scrollableName("widgets");
        Button createButton = Widgets.button((int)210, (int)178, (int)40, (int)18, (String)"Create").event(this::createDimlet);
        this.allFilter = ((ToggleButton)((ToggleButton)new ToggleButton().hint(210, 158, 40, 18)).text("All")).event(this::toggleAll);
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.searchBar, this.itemList, slider, createButton, this.allFilter});
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.dimletListAge = -1L;
        RFToolsDimMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((WorkbenchTileEntity)this.tileEntity).func_174877_v(), WorkbenchTileEntity.CMD_GETDIMLETS.getName()));
    }

    private void createDimlet() {
        this.sendServerCommandTyped(RFToolsDimMessages.INSTANCE, WorkbenchTileEntity.CMD_CREATE_DIMLET, TypedMap.builder().build());
    }

    private void hilightPattern() {
        DimletClientHelper.DimletWithInfo key;
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Panel widget = (Panel)this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletClientHelper.DimletWithInfo && (key = (DimletClientHelper.DimletWithInfo)userObject).isCraftable()) {
            DimletKey dimlet = key.getDimlet();
            this.sendServerCommandTyped(RFToolsDimMessages.INSTANCE, WorkbenchTileEntity.CMD_HILIGHT_PATTERN, TypedMap.builder().put(WorkbenchTileEntity.PARAM_TYPE, (Object)dimlet.getType().name()).put(WorkbenchTileEntity.PARAM_ID, (Object)dimlet.getKey()).build());
        }
    }

    public static void setPattern(String[] pattern) {
        GuiWorkbench.pattern = pattern;
    }

    private void renderHilightedPattern(MatrixStack matrixStack) {
        if (pattern != null) {
            net.minecraft.client.renderer.RenderHelper.func_227784_d_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)this.field_147003_i, (double)this.field_147009_r, 0.0);
            RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.enableRescaleNormal();
            this.field_230707_j_.field_77023_b = 100.0f;
            GlStateManager.func_227734_k_();
            GlStateManager.func_227737_l_();
            RenderSystem.enableLighting();
            for (int y = 0; y < pattern.length; ++y) {
                String p = pattern[y];
                for (int x = 0; x < p.length(); ++x) {
                    int slotIdx;
                    Slot slot;
                    ItemStack stack = KnowledgeManager.getPatternItem(p.charAt(x));
                    if (stack.func_190926_b() || (slot = ((GenericContainer)this.field_147002_h).func_75139_a(slotIdx = 5 + y * pattern.length + x)).func_75216_d()) continue;
                    this.field_230707_j_.func_180450_b(stack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f);
                    RenderSystem.disableLighting();
                    GlStateManager.func_227740_m_();
                    GlStateManager.func_227731_j_();
                    this.field_230706_i_.func_110434_K().func_110577_a(iconGuiElements);
                    RenderHelper.drawTexturedModalRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)slot.field_75223_e, (int)slot.field_75221_f, (int)224, (int)48, (int)16, (int)16);
                    GlStateManager.func_227734_k_();
                    GlStateManager.func_227737_l_();
                    RenderSystem.enableLighting();
                }
            }
            this.field_230707_j_.field_77023_b = 0.0f;
            matrixStack.func_227865_b_();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        }
    }

    private void cheatDimlet() {
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Panel widget = (Panel)this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletClientHelper.DimletWithInfo) {
            DimletClientHelper.DimletWithInfo key = (DimletClientHelper.DimletWithInfo)userObject;
            DimletKey dimlet = key.getDimlet();
            this.sendServerCommandTyped(RFToolsDimMessages.INSTANCE, WorkbenchTileEntity.CMD_CHEATDIMLET, TypedMap.builder().put(WorkbenchTileEntity.PARAM_TYPE, (Object)dimlet.getType().name()).put(WorkbenchTileEntity.PARAM_ID, (Object)dimlet.getKey()).build());
        }
    }

    private void suggestParts() {
        DimletClientHelper.DimletWithInfo key;
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Panel widget = (Panel)this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletClientHelper.DimletWithInfo && (key = (DimletClientHelper.DimletWithInfo)userObject).isCraftable()) {
            DimletKey dimlet = key.getDimlet();
            this.sendServerCommandTyped(RFToolsDimMessages.INSTANCE, WorkbenchTileEntity.CMD_SUGGESTPARTS, TypedMap.builder().put(WorkbenchTileEntity.PARAM_TYPE, (Object)dimlet.getType().name()).put(WorkbenchTileEntity.PARAM_ID, (Object)dimlet.getKey()).build());
        }
    }

    private void toggleAll() {
        this.dimletListAge = -1L;
    }

    private void search(String filter) {
        this.dimletListAge = -1L;
    }

    private void updateList() {
        if (this.dimletListAge == DimletClientHelper.dimletListAge) {
            return;
        }
        this.dimletListAge = DimletClientHelper.dimletListAge;
        this.itemList.removeChildren();
        String filter = this.searchBar.getText().toLowerCase();
        DimletClientHelper.dimlets.stream().filter(key -> this.dimletMatches(filter, (DimletClientHelper.DimletWithInfo)key)).sorted().forEachOrdered(this::addItemToList);
        if (this.itemList.getFirstSelected() >= this.itemList.getChildCount()) {
            this.itemList.setFirstSelected(0);
        }
    }

    private boolean dimletMatches(String filter, DimletClientHelper.DimletWithInfo key) {
        if (this.allFilter.isPressed() || key.isCraftable()) {
            DimletKey dimlet = key.getDimlet();
            String readableName = DimletTools.getReadableName(dimlet);
            return readableName.toLowerCase().contains(filter) || dimlet.getType().name().toLowerCase().contains(filter);
        }
        return false;
    }

    private void addItemToList(DimletClientHelper.DimletWithInfo key) {
        Panel panel = (Panel)((Panel)((Panel)Widgets.positional().desiredWidth(113)).desiredHeight(16)).userObject((Object)key);
        this.itemList.children(new Widget[]{panel});
        BlockRender blockRender = (BlockRender)((BlockRender)new BlockRender().renderItem((Object)DimletTools.getDimletStack(key.getDimlet())).hint(1, 0, 16, 16)).userObject((Object)key);
        panel.children(new Widget[]{blockRender});
        String displayName = DimletTools.getReadableName(key.getDimlet());
        AbstractWidget label = ((Label)((Label)((Label)Widgets.label((String)displayName).color(key.isCraftable() ? StyleConfig.colorTextInListNormal : StyleConfig.colorTextDisabled)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(20, 0, 95, 16)).userObject((Object)key);
        panel.children(new Widget[]{label});
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.updateList();
        this.drawWindow(matrixStack);
        this.renderHilightedPattern(matrixStack);
    }
}

