/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.client.DimletClientHelper;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.dimlets.items.PartItem;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import mcjty.rftoolsdim.modules.workbench.blocks.KnowledgeHolderTileEntity;
import mcjty.rftoolsdim.modules.workbench.network.PacketPatternToClient;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemHandlerHelper;

public class WorkbenchTileEntity
extends GenericTileEntity {
    public static final int SLOT_EMPTY_DIMLET = 0;
    public static final int SLOT_MEMORY_PART = 1;
    public static final int SLOT_ENERGY_PART = 2;
    public static final int SLOT_ESSENCE = 3;
    public static final int SLOT_OUTPUT = 4;
    public static final int SLOT_PATTERN = 5;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(41).slot(SlotDefinition.specific(DimletItem::isEmptyDimlet).in().out(), 0, 11, 7).slot(SlotDefinition.specific(s -> s.func_77973_b() instanceof PartItem).in().out(), 1, 33, 7).slot(SlotDefinition.specific(s -> s.func_77973_b() instanceof PartItem).in().out(), 2, 55, 7).slot(SlotDefinition.generic().in().out(), 3, 77, 7).slot(SlotDefinition.generic().out(), 4, 232, 216).box(SlotDefinition.specific(WorkbenchTileEntity::isValidPatternItem).in().out(), 5, 11, 28, 6, 6).playerSlots(11, 158));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        switch (slot) {
            case 0: {
                return DimletItem.isEmptyDimlet(stack);
            }
            case 1: {
                return stack.func_77973_b() instanceof PartItem;
            }
            case 2: {
                return stack.func_77973_b() instanceof PartItem;
            }
            case 3: {
                return true;
            }
            case 4: {
                return DimletItem.isReadyDimlet(stack);
            }
        }
        return WorkbenchTileEntity.isValidPatternItem(stack);
    }).insertable(GenericItemHandler.notslot((int)4)).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dimlet Workbench").containerSupplier(DefaultContainerProvider.container(WorkbenchModule.CONTAINER_WORKBENCH, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_ID = new Key("id", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_SUGGESTPARTS = Command.create((String)"workbench.suggestParts", (te, player, params) -> te.suggestParts(player, new DimletKey(DimletType.byName((String)params.get(PARAM_TYPE)), (String)params.get(PARAM_ID))));
    @ServerCommand
    public static final Command<?> CMD_CHEATDIMLET = Command.create((String)"workbench.cheatDimlet", (te, player, params) -> te.cheatDimlet(player, new DimletKey(DimletType.byName((String)params.get(PARAM_TYPE)), (String)params.get(PARAM_ID))));
    @ServerCommand
    public static final Command<?> CMD_HILIGHT_PATTERN = Command.create((String)"workbench.hilightPattern", (te, player, params) -> te.hilightPattern(player, new DimletKey(DimletType.byName((String)params.get(PARAM_TYPE)), (String)params.get(PARAM_ID))));
    @ServerCommand
    public static final Command<?> CMD_CREATE_DIMLET = Command.create((String)"workbench.createDimlet", (te, player, params) -> te.createDimlet());
    @ServerCommand(type=DimletClientHelper.DimletWithInfo.class, serializer=DimletClientHelper.DimletWithInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETDIMLETS = ListCommand.create((String)"rftoolsdim.workbench.getdimlets", (te, player, params) -> te.getDimlets(), (te, player, params, list) -> DimletClientHelper.setDimletsOnGui(list));

    public WorkbenchTileEntity() {
        super((TileEntityType)WorkbenchModule.TYPE_WORKBENCH.get());
    }

    private static boolean isValidPatternItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Registration.DIMENSIONAL_SHARD || item == DimletModule.COMMON_ESSENCE.get() || item == DimletModule.RARE_ESSENCE.get() || item == DimletModule.LEGENDARY_ESSENCE.get();
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(WorkbenchTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }
        };
    }

    private boolean createDimlet() {
        ItemStack emptyDimlet = this.items.getStackInSlot(0);
        ItemStack memoryPart = this.items.getStackInSlot(1);
        ItemStack energyPart = this.items.getStackInSlot(2);
        ItemStack essenceStack = this.items.getStackInSlot(3);
        DimletType type = DimletItem.getType(emptyDimlet);
        if (type == null) {
            return false;
        }
        if (memoryPart.func_190926_b()) {
            return false;
        }
        if (energyPart.func_190926_b()) {
            return false;
        }
        String[] pattern = new String[6];
        int slot = 5;
        for (int y = 0; y < 6; ++y) {
            String p = "";
            for (int x = 0; x < 6; ++x) {
                ItemStack stack = this.items.getStackInSlot(slot);
                char c = KnowledgeManager.getPatternChar(stack);
                p = p + c;
                ++slot;
            }
            pattern[y] = p;
        }
        DimletKey key = DimletDictionary.get().tryCraft(this.field_145850_b, type, memoryPart, energyPart, essenceStack, new DimletPattern(pattern));
        if (key == null) {
            return false;
        }
        ItemStack dimletStack = DimletTools.getDimletStack(key);
        if (dimletStack.func_190926_b()) {
            return false;
        }
        this.items.decrStackSize(0, 1);
        this.items.decrStackSize(1, 1);
        this.items.decrStackSize(2, 1);
        this.items.decrStackSize(3, 1);
        for (int i = 5; i <= 41; ++i) {
            this.items.decrStackSize(i, 1);
        }
        this.items.setStackInSlot(4, dimletStack);
        return true;
    }

    private void cheatDimlet(PlayerEntity player, DimletKey key) {
        ItemStack dimlet = DimletTools.getDimletStack(key);
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)dimlet);
    }

    private void hilightPattern(PlayerEntity player, DimletKey key) {
        DimletPattern pattern = KnowledgeManager.get().getPattern(LevelTools.getOverworld((World)player.field_70170_p).func_72905_C(), key);
        if (pattern != null) {
            String[] p = pattern.getPattern();
            RFToolsDimMessages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PacketPatternToClient(p));
        }
    }

    private void suggestParts(PlayerEntity player, DimletKey key) {
        if (!key.getType().usesKnowledgeSystem()) {
            return;
        }
        this.tryFindAndFitItem(player, s -> s.func_77969_a(DimletTools.getEmptyDimletStack(key.getType())), 0);
        this.tryFindAndFitItem(player, s -> s.func_77969_a(DimletTools.getNeededMemoryPart(key)), 1);
        this.tryFindAndFitItem(player, s -> s.func_77969_a(DimletTools.getNeededEnergyPart(key)), 2);
        ItemStack essence = DimletTools.getNeededEssence(key, DimletDictionary.get().getSettings(key));
        if (!essence.func_190926_b()) {
            this.tryFindAndFitItem(player, s -> DimletTools.isFullEssence(s, essence, key.getKey()), 3);
        } else {
            this.tryFindAndFitItem(player, s -> false, 3);
        }
        DimletPattern pattern = KnowledgeManager.get().getPattern(LevelTools.getOverworld((World)this.field_145850_b).func_72905_C(), key);
        if (pattern != null) {
            String[] p = pattern.getPattern();
            int slotNumber = 5;
            for (String value : p) {
                for (int x = 0; x < value.length(); ++x) {
                    ItemStack neededPattern = KnowledgeManager.getPatternItem(value.charAt(x));
                    if (!neededPattern.func_190926_b()) {
                        this.tryFindAndFitItem(player, s -> s.func_77969_a(neededPattern), slotNumber);
                    } else {
                        this.tryFindAndFitItem(player, s -> false, slotNumber);
                    }
                    ++slotNumber;
                }
            }
        }
        player.field_71069_bz.func_75142_b();
    }

    private void tryFindAndFitItem(PlayerEntity player, Predicate<ItemStack> desired, int slotNumber) {
        if (desired.test(this.items.getStackInSlot(slotNumber))) {
            return;
        }
        if (!this.items.getStackInSlot(slotNumber).func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.items.getStackInSlot(slotNumber));
            this.items.setStackInSlot(slotNumber, ItemStack.field_190927_a);
        }
        NonNullList inventory = player.field_71071_by.field_70462_a;
        for (ItemStack itemStack : inventory) {
            if (!desired.test(itemStack)) continue;
            ItemStack copy = itemStack.func_77946_l();
            copy.func_190920_e(1);
            this.items.setStackInSlot(slotNumber, copy);
            itemStack.func_190918_g(1);
            return;
        }
    }

    private Set<KnowledgeKey> getSupportedKnowledgeKeys() {
        HashSet<KnowledgeKey> knownKeys = new HashSet<KnowledgeKey>();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (!(tileEntity instanceof KnowledgeHolderTileEntity)) continue;
            ((KnowledgeHolderTileEntity)tileEntity).addKnownKnowledgeKeys(knownKeys);
        }
        return knownKeys;
    }

    public List<DimletClientHelper.DimletWithInfo> getDimlets() {
        Set<KnowledgeKey> knownKeys = this.getSupportedKnowledgeKeys();
        ArrayList<DimletClientHelper.DimletWithInfo> dimlets = new ArrayList<DimletClientHelper.DimletWithInfo>();
        for (DimletKey dimlet : DimletDictionary.get().getDimlets()) {
            KnowledgeKey kkey = KnowledgeManager.get().getKnowledgeKey(LevelTools.getOverworld((World)this.field_145850_b).func_72905_C(), dimlet);
            boolean craftable = knownKeys.contains(kkey);
            dimlets.add(new DimletClientHelper.DimletWithInfo(dimlet, craftable));
        }
        return dimlets;
    }
}

