/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.data;

import java.util.Objects;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;

public class KnowledgeKey {
    private final DimletType type;
    private final DimletRarity rarity;
    private final KnowledgeSet set;

    public KnowledgeKey(DimletType type, DimletRarity rarity, KnowledgeSet set) {
        this.type = type;
        this.rarity = rarity;
        this.set = set;
    }

    public KnowledgeKey(String data) {
        String[] split = data.split(":");
        this.type = DimletType.byName(split[0]);
        this.rarity = DimletRarity.byName(split[1]);
        this.set = KnowledgeSet.valueOf(split[2]);
    }

    public DimletType getType() {
        return this.type;
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    public KnowledgeSet getSet() {
        return this.set;
    }

    public String serialize() {
        return this.type.getShortName() + ":" + this.rarity.getShortName() + ":" + this.set.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeKey that = (KnowledgeKey)o;
        return this.type == that.type && this.rarity == that.rarity && this.set == that.set;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.rarity, this.set});
    }
}

