/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import java.util.Objects;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.network.PacketBuffer;

public class DimletKey
implements Comparable<DimletKey> {
    private final DimletType type;
    private final String key;

    public DimletKey(DimletType type, String key) {
        this.type = type;
        this.key = key;
    }

    public DimletKey(PacketBuffer buf) {
        this.type = DimletType.values()[buf.readInt()];
        this.key = buf.func_150789_c(Short.MAX_VALUE);
    }

    public DimletKey(String serialized) {
        String[] split = serialized.split("#");
        this.type = DimletType.byName(split[0]);
        this.key = split[1];
    }

    public DimletType getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String serialize() {
        return this.type.getShortName() + "#" + this.key;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.type.ordinal());
        buf.func_180714_a(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimletKey dimletKey = (DimletKey)o;
        return this.type == dimletKey.type && Objects.equals(this.key, dimletKey.key);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key});
    }

    @Override
    public int compareTo(DimletKey dimletKey) {
        if (dimletKey.getType().equals((Object)this.type)) {
            return this.key.compareTo(dimletKey.key);
        }
        return this.type.name().compareTo(dimletKey.type.name());
    }
}

