/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.entities;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.modules.blob.BlobConfig;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DimensionalBlobEntity
extends MonsterEntity {
    private float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private final DimletRarity rarity;
    private AxisAlignedBB targetBox = null;
    private int tickCounter = 5;
    private static final EntityPredicate PREDICATE = new EntityPredicate().func_221014_c();

    public DimensionalBlobEntity(EntityType<? extends MonsterEntity> type, World worldIn, DimletRarity rarity) {
        super(type, worldIn);
        this.rarity = rarity;
        this.calculateTargetBox(this.func_174813_aQ());
    }

    private static int getDefaultMaxHealth(DimletRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return (Integer)BlobConfig.BLOB_COMMON_HEALTH.get();
            }
            case RARE: {
                return (Integer)BlobConfig.BLOB_RARE_HEALTH.get();
            }
            case LEGENDARY: {
                return (Integer)BlobConfig.BLOB_LEGENDARY_HEALTH.get();
            }
            case UNCOMMON: {
                throw new IllegalStateException("There is no uncommon blob!");
            }
        }
        throw new IllegalStateException("Unknown blob type!");
    }

    private int getRegenLevel() {
        switch (this.rarity) {
            case COMMON: {
                return (Integer)BlobConfig.BLOB_COMMON_REGEN.get();
            }
            case UNCOMMON: {
                throw new IllegalStateException("There is no uncommon blob!");
            }
            case RARE: {
                return (Integer)BlobConfig.BLOB_RARE_REGEN.get();
            }
            case LEGENDARY: {
                return (Integer)BlobConfig.BLOB_LEGENDARY_REGEN.get();
            }
        }
        throw new IllegalStateException("Unknown blob type!");
    }

    public void func_70636_d() {
        DimensionData data;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && (data = PersistantDimensionManager.get(this.field_70170_p).getData(this.field_70170_p.func_234923_W_().func_240901_a_())) != null && data.getEnergy() >= (Long)BlobConfig.BLOB_REGENERATION_LEVEL.get()) {
            --this.tickCounter;
            if (this.tickCounter <= 0) {
                this.tickCounter = 5;
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 20, this.getRegenLevel()));
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ModifiableAttributeInstance attr = this.func_233645_dx_().func_233779_a_(Attributes.field_233818_a_);
        if (attr != null) {
            attr.func_111128_a((double)DimensionalBlobEntity.getDefaultMaxHealth(this.rarity));
            this.func_70606_j(DimensionalBlobEntity.getDefaultMaxHealth(this.rarity));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes(DimletRarity rarity) {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233818_a_, (double)DimensionalBlobEntity.getDefaultMaxHealth(rarity));
    }

    public float func_213355_cm() {
        switch (this.rarity) {
            case COMMON: 
            case UNCOMMON: {
                return 1.5f;
            }
            case RARE: {
                return 2.2f;
            }
            case LEGENDARY: {
                return 4.7f;
            }
        }
        return 1.0f;
    }

    public void func_174826_a(@Nonnull AxisAlignedBB bb) {
        super.func_174826_a(bb);
        this.calculateTargetBox(bb);
    }

    private void calculateTargetBox(AxisAlignedBB bb) {
        if (this.rarity != null) {
            double radius = 1.0;
            switch (this.rarity) {
                case COMMON: 
                case UNCOMMON: {
                    radius = 5.0;
                    break;
                }
                case RARE: {
                    radius = 9.0;
                    break;
                }
                case LEGENDARY: {
                    radius = 15.0;
                }
            }
            this.targetBox = bb.func_186662_g(radius);
        }
    }

    private void infectPlayer(PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76438_s, 100));
        player.func_195064_c(new EffectInstance(Effects.field_76437_t, 100));
        switch (this.rarity) {
            case COMMON: 
            case UNCOMMON: {
                break;
            }
            case RARE: {
                player.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
                break;
            }
            case LEGENDARY: {
                player.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
                player.func_195064_c(new EffectInstance(Effects.field_82731_v, 100));
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
            this.prevSquishFactor = this.squishFactor;
            if (this.field_70146_Z.nextFloat() < 0.03f) {
                this.squishAmount = -0.5f;
            } else if (this.field_70146_Z.nextFloat() < 0.03f) {
                this.squishAmount = 1.0f;
            }
            this.squishAmount *= 0.6f;
        } else if ((double)this.field_70146_Z.nextFloat() < 0.05) {
            List players = this.field_70170_p.func_217373_a(PREDICATE, (LivingEntity)this, this.targetBox);
            for (PlayerEntity player : players) {
                this.infectPlayer(player);
            }
        }
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

