/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.BaseChunkGenerator;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;

public class NormalChunkGenerator
extends BaseChunkGenerator {
    public static final Codec<NormalChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(BaseChunkGenerator::getBiomeRegistry), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("settings").forGetter(BaseChunkGenerator::getDimensionSettings)).apply((Applicative)instance, NormalChunkGenerator::new));
    private static final float[] FLOATS1 = (float[])Util.func_200696_a((Object)new float[13824], floats -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    floats[i * 24 * 24 + j * 24 + k] = (float)NormalChunkGenerator.computeContribution(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final float[] FLOAT25 = (float[])Util.func_200696_a((Object)new float[25], floats -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                floats[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    public static final int SETTING_DEFAULT_OVERWORLD = 0;
    public static final int SETTING_FLAT_OVERWORLD = 1;
    public static final int SETTING_ELEVATED_OVERWORLD = 2;
    public static final int SETTING_DEFAULT_ISLANDS = 3;
    public static final int SETTING_FLAT_ISLANDS = 4;
    public static final int SETTING_ELEVATED_ISLANDS = 5;
    private static final NoiseSettings[] SETTINGS = new NoiseSettings[]{new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, false), new NoiseSettings(128, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, false), new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, true), new NoiseSettings(128, new ScalingSettings(2.0, 1.0, 80.0, 160.0), new SlideSettings(-3000, 64, -46), new SlideSettings(-30, 7, 1), 2, 1, 0.0, 0.0, true, false, false, false), new NoiseSettings(64, new ScalingSettings(2.0, 1.0, 80.0, 160.0), new SlideSettings(-3000, 64, -46), new SlideSettings(-30, 7, 1), 2, 1, 0.0, 0.0, true, false, false, false), new NoiseSettings(128, new ScalingSettings(2.0, 1.0, 80.0, 160.0), new SlideSettings(-3000, 64, -46), new SlideSettings(-30, 7, 1), 2, 1, 0.0, 0.0, true, false, false, true)};
    private final int noiseIndex;
    private final OctavesNoiseGenerator oct1;
    private final OctavesNoiseGenerator oct2;
    private final OctavesNoiseGenerator oct3;
    private final OctavesNoiseGenerator oct4;
    private final SimplexNoiseGenerator simplexNoise;
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;

    public NormalChunkGenerator(MinecraftServer server, DimensionSettings settings) {
        this((Registry<Biome>)server.func_244267_aX().func_243612_b(Registry.field_239720_u_), settings, 0);
    }

    public NormalChunkGenerator(Registry<Biome> registry, DimensionSettings settings) {
        this(registry, settings, 0);
    }

    protected NormalChunkGenerator(MinecraftServer server, DimensionSettings settings, int idx) {
        this((Registry<Biome>)server.func_244267_aX().func_243612_b(Registry.field_239720_u_), settings, idx);
    }

    protected NormalChunkGenerator(Registry<Biome> registry, DimensionSettings settings, int idx) {
        super(registry, settings);
        if (settings.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.FLATTER)) {
            ++idx;
        } else if (settings.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.ELEVATED)) {
            idx += 2;
        }
        this.noiseIndex = idx;
        NoiseSettings ns = SETTINGS[idx];
        this.verticalNoiseGranularity = ns.func_236175_f_() * 4;
        this.horizontalNoiseGranularity = ns.func_236174_e_() * 4;
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = ns.func_236169_a_() / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        this.oct1 = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-15, 0));
        this.oct2 = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-15, 0));
        this.oct4 = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-7, 0));
        this.surfaceDepthNoise = ns.func_236178_i_() ? new PerlinNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-3, 0)) : new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-3, 0));
        this.randomSeed.func_202423_a(2620);
        this.oct3 = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-15, 0));
        if (ns.func_236180_k_()) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(settings.getSeed());
            sharedseedrandom.func_202423_a(17292);
            this.simplexNoise = new SimplexNoiseGenerator((Random)sharedseedrandom);
        } else {
            this.simplexNoise = null;
        }
    }

    @Nonnull
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @Nonnull
    public ChunkGenerator func_230349_a_(long l) {
        return new NormalChunkGenerator(this.getBiomeRegistry(), this.getDimensionSettings());
    }

    public void func_230352_b_(@Nonnull IWorld world, @Nonnull StructureManager structureManager, IChunk chunk) {
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunk.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int cx = chunkX << 4;
        int cz = chunkZ << 4;
        for (Structure structure : Structure.field_236384_t_) {
            structureManager.func_235011_a_(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)0), structure).forEach(arg_0 -> NormalChunkGenerator.lambda$fillFromNoise$3(chunkpos, (ObjectList)objectlist, cx, cz, (ObjectList)objectlist1, arg_0));
        }
        double[][][] adouble = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int nz = 0; nz < this.noiseSizeZ + 1; ++nz) {
            adouble[0][nz] = new double[this.noiseSizeY + 1];
            this.fillNoiseColumn(adouble[0][nz], chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ + nz);
            adouble[1][nz] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunk;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        ObjectListIterator iterator = objectlist.iterator();
        ObjectListIterator iterator1 = objectlist1.iterator();
        for (int nx = 0; nx < this.noiseSizeX; ++nx) {
            int nz;
            for (nz = 0; nz < this.noiseSizeZ + 1; ++nz) {
                this.fillNoiseColumn(adouble[1][nz], chunkX * this.noiseSizeX + nx + 1, chunkZ * this.noiseSizeZ + nz);
            }
            for (nz = 0; nz < this.noiseSizeZ; ++nz) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int ny = this.noiseSizeY - 1; ny >= 0; --ny) {
                    double d0 = adouble[0][nz][ny];
                    double d1 = adouble[0][nz + 1][ny];
                    double d2 = adouble[1][nz][ny];
                    double d3 = adouble[1][nz + 1][ny];
                    double d4 = adouble[0][nz][ny + 1];
                    double d5 = adouble[0][nz + 1][ny + 1];
                    double d6 = adouble[1][nz][ny + 1];
                    double d7 = adouble[1][nz + 1][ny + 1];
                    for (int vertN = this.verticalNoiseGranularity - 1; vertN >= 0; --vertN) {
                        int yy = ny * this.verticalNoiseGranularity + vertN;
                        int j2 = yy & 0xF;
                        int k2 = yy >> 4;
                        if (chunksection.func_222632_g() >> 4 != k2) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(k2);
                            chunksection.func_222635_a();
                        }
                        double d8 = (double)vertN / (double)this.verticalNoiseGranularity;
                        double d9 = MathHelper.func_219803_d((double)d8, (double)d0, (double)d4);
                        double d10 = MathHelper.func_219803_d((double)d8, (double)d2, (double)d6);
                        double d11 = MathHelper.func_219803_d((double)d8, (double)d1, (double)d5);
                        double d12 = MathHelper.func_219803_d((double)d8, (double)d3, (double)d7);
                        for (int horN = 0; horN < this.horizontalNoiseGranularity; ++horN) {
                            int i3 = cx + nx * this.horizontalNoiseGranularity + horN;
                            int xx = i3 & 0xF;
                            double d13 = (double)horN / (double)this.horizontalNoiseGranularity;
                            double d14 = MathHelper.func_219803_d((double)d13, (double)d9, (double)d10);
                            double d15 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                            for (int horZ = 0; horZ < this.horizontalNoiseGranularity; ++horZ) {
                                int k4;
                                int j4;
                                int l3 = cz + nz * this.horizontalNoiseGranularity + horZ;
                                int zz = l3 & 0xF;
                                double d16 = (double)horZ / (double)this.horizontalNoiseGranularity;
                                double d17 = MathHelper.func_219803_d((double)d16, (double)d14, (double)d15);
                                double d18 = MathHelper.func_151237_a((double)(d17 / 200.0), (double)-1.0, (double)1.0);
                                d18 = d18 / 2.0 - d18 * d18 * d18 / 24.0;
                                while (iterator.hasNext()) {
                                    StructurePiece structurepiece = (StructurePiece)iterator.next();
                                    MutableBoundingBox mbox = structurepiece.func_74874_b();
                                    j4 = Math.max(0, Math.max(mbox.field_78897_a - i3, i3 - mbox.field_78893_d));
                                    k4 = yy - (mbox.field_78895_b + (structurepiece instanceof AbstractVillagePiece ? ((AbstractVillagePiece)structurepiece).func_214830_d() : 0));
                                    int l4 = Math.max(0, Math.max(mbox.field_78896_c - l3, l3 - mbox.field_78892_f));
                                    d18 += NormalChunkGenerator.getContribution(j4, k4, l4) * 0.8;
                                }
                                iterator.back(objectlist.size());
                                while (iterator1.hasNext()) {
                                    JigsawJunction jigsawjunction = (JigsawJunction)iterator1.next();
                                    int k5 = i3 - jigsawjunction.func_214895_a();
                                    j4 = yy - jigsawjunction.func_214896_b();
                                    k4 = l3 - jigsawjunction.func_214893_c();
                                    d18 += NormalChunkGenerator.getContribution(k5, j4, k4) * 0.4;
                                }
                                iterator1.back(objectlist1.size());
                                BlockState blockstate = this.generateBaseState(d18, yy);
                                if (blockstate == Blocks.field_150350_a.func_176223_P()) continue;
                                mpos.func_181079_c(i3, yy, l3);
                                if (blockstate.getLightValue((IBlockReader)chunkprimer, (BlockPos)mpos) != 0) {
                                    chunkprimer.func_201637_h((BlockPos)mpos);
                                }
                                chunksection.func_177484_a(xx, j2, zz, blockstate, false);
                                heightmap.func_202270_a(xx, yy, zz, blockstate);
                                heightmap1.func_202270_a(xx, yy, zz, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = adouble[0];
            adouble[0] = adouble[1];
            adouble[1] = adouble1;
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type type) {
        return this.iterateNoiseColumn(x, z, null, type.func_222684_d());
    }

    @Nonnull
    public IBlockReader func_230348_a_(int x, int z) {
        BlockState[] ablockstate = new BlockState[this.noiseSizeY * this.verticalNoiseGranularity];
        this.iterateNoiseColumn(x, z, ablockstate, null);
        return new Blockreader(ablockstate);
    }

    private static double computeContribution(int x, int y, int z) {
        double d0 = x * x + z * z;
        double d1 = (double)y + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }

    private void fillNoiseColumn(double[] noiseColumn, int noiseX, int noiseZ) {
        double d1;
        double d0;
        if (this.simplexNoise != null) {
            d0 = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.simplexNoise, (int)noiseX, (int)noiseZ) - 8.0f;
            d1 = d0 > 0.0 ? 0.25 : 1.0;
        } else {
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            int i = 2;
            int j = this.func_230356_f_();
            float f3 = this.field_222542_c.func_225526_b_(noiseX, j, noiseZ).func_185355_j();
            for (int k = -2; k <= 2; ++k) {
                for (int l = -2; l <= 2; ++l) {
                    float f7;
                    float f6;
                    Biome biome = this.field_222542_c.func_225526_b_(noiseX + k, j, noiseZ + l);
                    float f4 = biome.func_185355_j();
                    float f5 = biome.func_185360_m();
                    if (SETTINGS[this.noiseIndex].func_236181_l_() && f4 > 0.0f) {
                        f6 = 1.0f + f4 * 2.0f;
                        f7 = 1.0f + f5 * 4.0f;
                    } else {
                        f6 = f4;
                        f7 = f5;
                    }
                    float f8 = f4 > f3 ? 0.5f : 1.0f;
                    float f9 = f8 * FLOAT25[k + 2 + (l + 2) * 5] / (f6 + 2.0f);
                    f += f7 * f9;
                    f1 += f6 * f9;
                    f2 += f9;
                }
            }
            float f10 = f1 / f2;
            float f11 = f / f2;
            double d16 = f10 * 0.5f - 0.125f;
            double d18 = f11 * 0.9f + 0.1f;
            d0 = d16 * 0.265625;
            d1 = 96.0 / d18;
        }
        NoiseSettings ns = SETTINGS[this.noiseIndex];
        double d12 = 684.412 * ns.func_236171_b_().func_236151_a_();
        double d13 = 684.412 * ns.func_236171_b_().func_236153_b_();
        double d14 = d12 / ns.func_236171_b_().func_236154_c_();
        double d15 = d13 / ns.func_236171_b_().func_236155_d_();
        double d17 = ns.func_236172_c_().func_236186_a_();
        double d19 = ns.func_236172_c_().func_236188_b_();
        double d20 = ns.func_236172_c_().func_236189_c_();
        double d21 = ns.func_236173_d_().func_236186_a_();
        double d2 = ns.func_236173_d_().func_236188_b_();
        double d3 = ns.func_236173_d_().func_236189_c_();
        double d4 = ns.func_236179_j_() ? this.getRandomDensity(noiseX, noiseZ) : 0.0;
        double d5 = ns.func_236176_g_();
        double d6 = ns.func_236177_h_();
        for (int i1 = 0; i1 <= this.noiseSizeY; ++i1) {
            double d7 = this.sampleAndClampNoise(noiseX, i1, noiseZ, d12, d13, d14, d15);
            double d8 = 1.0 - (double)i1 * 2.0 / (double)this.noiseSizeY + d4;
            double d9 = d8 * d5 + d6;
            double d10 = (d9 + d0) * d1;
            d7 = d10 > 0.0 ? (d7 += d10 * 4.0) : (d7 += d10);
            if (d19 > 0.0) {
                double d11 = ((double)(this.noiseSizeY - i1) - d20) / d19;
                d7 = MathHelper.func_151238_b((double)d17, (double)d7, (double)d11);
            }
            if (d2 > 0.0) {
                double d22 = ((double)i1 - d3) / d2;
                d7 = MathHelper.func_151238_b((double)d21, (double)d7, (double)d22);
            }
            noiseColumn[i1] = d7;
        }
    }

    private double getRandomDensity(int x, int z) {
        double d0 = this.oct3.func_215462_a((double)(x * 200), 10.0, (double)(z * 200), 1.0, 0.0, true);
        double d1 = d0 < 0.0 ? -d0 * 0.3 : d0;
        double d2 = d1 * 24.575625 - 2.0;
        return d2 < 0.0 ? d2 * 0.009486607142857142 : Math.min(d2, 1.0) * 0.006640625;
    }

    private double sampleAndClampNoise(int x, int y, int z, double p_222552_4_, double p_222552_6_, double p_222552_8_, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        boolean flag = true;
        double d3 = 1.0;
        for (int i = 0; i < 16; ++i) {
            ImprovedNoiseGenerator improvednoisegenerator2;
            ImprovedNoiseGenerator improvednoisegenerator1;
            double d4 = OctavesNoiseGenerator.func_215461_a((double)((double)x * p_222552_4_ * d3));
            double d5 = OctavesNoiseGenerator.func_215461_a((double)((double)y * p_222552_6_ * d3));
            double d6 = OctavesNoiseGenerator.func_215461_a((double)((double)z * p_222552_4_ * d3));
            double d7 = p_222552_6_ * d3;
            ImprovedNoiseGenerator improvednoisegenerator = this.oct1.func_215463_a(i);
            if (improvednoisegenerator != null) {
                d0 += improvednoisegenerator.func_215456_a(d4, d5, d6, d7, (double)y * d7) / d3;
            }
            if ((improvednoisegenerator1 = this.oct2.func_215463_a(i)) != null) {
                d1 += improvednoisegenerator1.func_215456_a(d4, d5, d6, d7, (double)y * d7) / d3;
            }
            if (i < 8 && (improvednoisegenerator2 = this.oct4.func_215463_a(i)) != null) {
                d2 += improvednoisegenerator2.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)x * p_222552_8_ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)y * p_222552_10_ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)z * p_222552_8_ * d3)), p_222552_10_ * d3, (double)y * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((d2 / 10.0 + 1.0) / 2.0));
    }

    private double[] makeAndFillNoiseColumn(int x, int y) {
        double[] adouble = new double[this.noiseSizeY + 1];
        this.fillNoiseColumn(adouble, x, y);
        return adouble;
    }

    private static double getContribution(int x, int y, int z) {
        int xx = x + 12;
        int yy = y + 12;
        int zz = z + 12;
        if (xx >= 0 && xx < 24) {
            if (yy >= 0 && yy < 24) {
                return zz >= 0 && zz < 24 ? (double)FLOATS1[zz * 24 * 24 + xx * 24 + yy] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private BlockState generateBaseState(double p_236086_1_, int p_236086_3_) {
        BlockState blockstate = p_236086_1_ > 0.0 ? this.getDefaultBlock() : (p_236086_3_ < this.func_230356_f_() ? this.getBaseLiquid() : Blocks.field_150350_a.func_176223_P());
        return blockstate;
    }

    private int iterateNoiseColumn(int x, int z, @Nullable BlockState[] states, @Nullable Predicate<BlockState> tester) {
        int i = NormalChunkGenerator.floorDiv(x, this.horizontalNoiseGranularity);
        int j = NormalChunkGenerator.floorDiv(z, this.horizontalNoiseGranularity);
        int k = NormalChunkGenerator.floorMod(x, this.horizontalNoiseGranularity);
        int l = NormalChunkGenerator.floorMod(z, this.horizontalNoiseGranularity);
        double d0 = (double)k / (double)this.horizontalNoiseGranularity;
        double d1 = (double)l / (double)this.horizontalNoiseGranularity;
        double[][] adouble = new double[][]{this.makeAndFillNoiseColumn(i, j), this.makeAndFillNoiseColumn(i, j + 1), this.makeAndFillNoiseColumn(i + 1, j), this.makeAndFillNoiseColumn(i + 1, j + 1)};
        for (int i1 = this.noiseSizeY - 1; i1 >= 0; --i1) {
            double d2 = adouble[0][i1];
            double d3 = adouble[1][i1];
            double d4 = adouble[2][i1];
            double d5 = adouble[3][i1];
            double d6 = adouble[0][i1 + 1];
            double d7 = adouble[1][i1 + 1];
            double d8 = adouble[2][i1 + 1];
            double d9 = adouble[3][i1 + 1];
            for (int j1 = this.verticalNoiseGranularity - 1; j1 >= 0; --j1) {
                double d10 = (double)j1 / (double)this.verticalNoiseGranularity;
                double d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int k1 = i1 * this.verticalNoiseGranularity + j1;
                BlockState blockstate = this.generateBaseState(d11, k1);
                if (states != null) {
                    states[k1] = blockstate;
                }
                if (tester == null || !tester.test(blockstate)) continue;
                return k1 + 1;
            }
        }
        return 0;
    }

    public static int floorMod(int a, int b) {
        return a - NormalChunkGenerator.floorDiv(a, b) * b;
    }

    public static int floorDiv(int a, int b) {
        int divider = a / b;
        if ((a ^ b) < 0 && divider * b != a) {
            --divider;
        }
        return divider;
    }

    private static /* synthetic */ void lambda$fillFromNoise$3(ChunkPos chunkpos, ObjectList objectlist, int cx, int cz, ObjectList objectlist1, StructureStart p_236089_5_) {
        for (StructurePiece piece : p_236089_5_.func_186161_c()) {
            if (!piece.func_214810_a(chunkpos, 12)) continue;
            if (piece instanceof AbstractVillagePiece) {
                AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)piece;
                JigsawPattern.PlacementBehaviour placementBehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                if (placementBehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                    objectlist.add((Object)abstractvillagepiece);
                }
                for (JigsawJunction jigsawjunction1 : abstractvillagepiece.func_214829_e()) {
                    int sourceX = jigsawjunction1.func_214895_a();
                    int sourceZ = jigsawjunction1.func_214893_c();
                    if (sourceX <= cx - 12 || sourceZ <= cz - 12 || sourceX >= cx + 15 + 12 || sourceZ >= cz + 15 + 12) continue;
                    objectlist1.add((Object)jigsawjunction1);
                }
                continue;
            }
            objectlist.add((Object)piece);
        }
    }
}

