/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;

public class RFTBiomeProvider
extends BiomeProvider {
    public static final Codec<RFTBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(RFTBiomeProvider::getBiomeRegistry), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("settings").forGetter(RFTBiomeProvider::getSettings)).apply((Applicative)instance, RFTBiomeProvider::new));
    private final Layer genBiomes;
    private final List<Biome> biomes;
    private final Registry<Biome> biomeRegistry;
    private final DimensionSettings settings;

    public RFTBiomeProvider(Registry<Biome> biomeRegistry, DimensionSettings settings) {
        super(RFTBiomeProvider.getBiomes(biomeRegistry, settings));
        this.settings = settings;
        this.biomeRegistry = biomeRegistry;
        this.biomes = RFTBiomeProvider.getBiomes(biomeRegistry, settings);
        this.genBiomes = LayerUtil.func_237215_a_((long)settings.getSeed(), (boolean)false, (int)4, (int)4);
    }

    public DimensionSettings getSettings() {
        return this.settings;
    }

    private static List<Biome> getBiomes(Registry<Biome> biomeRegistry, DimensionSettings settings) {
        List<Biome> biomes = settings.getCompiledDescriptor().getBiomes().stream().map(arg_0 -> biomeRegistry.func_82594_a(arg_0)).collect(Collectors.toList());
        if (biomes.isEmpty()) {
            biomes.add((Biome)biomeRegistry.func_82594_a(Biomes.field_76772_c.func_240901_a_()));
        }
        return biomes;
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public boolean func_205004_a(@Nonnull Structure<?> structure) {
        return false;
    }

    @Nonnull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @Nonnull
    public BiomeProvider func_230320_a_(long seed) {
        return new RFTBiomeProvider(this.getBiomeRegistry(), this.settings);
    }

    @Nonnull
    public Biome func_225526_b_(int x, int y, int z) {
        switch (this.settings.getCompiledDescriptor().getBiomeControllerType()) {
            case DEFAULT: {
                return this.genBiomes.func_242936_a(this.biomeRegistry, x, z);
            }
            case CHECKER: {
                if ((x + y) % 2 == 0 || this.biomes.size() <= 1) {
                    return this.biomes.get(0);
                }
                return this.biomes.get(1);
            }
            case SINGLE: {
                return this.biomes.get(0);
            }
        }
        return null;
    }
}

