/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import mcjty.lib.varia.Check32;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.shapes.ShapeBlockInfo;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IFormula {
    public void setup(World var1, BlockPos var2, BlockPos var3, BlockPos var4, CompoundNBT var5);

    default public void getCheckSumClient(CompoundNBT cardTag, Check32 crc) {
        ShapeCardItem.getLocalChecksum(cardTag, crc);
    }

    public boolean isInside(int var1, int var2, int var3);

    default public boolean isInsideSafe(int x, int y, int z) {
        return this.isInside(x, y, z);
    }

    default public BlockState getLastState() {
        return null;
    }

    default public boolean isBorder(int x, int y, int z) {
        if (!(this.isInsideSafe(x - 1, y, z) && this.isInsideSafe(x + 1, y, z) && this.isInsideSafe(x, y, z - 1) && this.isInsideSafe(x, y, z + 1) && this.isInsideSafe(x, y - 1, z) && this.isInsideSafe(x, y + 1, z))) {
            return this.isInside(x, y, z);
        }
        return false;
    }

    default public boolean isVisible(int x, int y, int z) {
        return this.isClear(x - 1, y, z) || this.isClear(x + 1, y, z) || this.isClear(x, y - 1, z) || this.isClear(x, y + 1, z) || this.isClear(x, y, z - 1) || this.isClear(x, y, z + 1);
    }

    default public boolean isClear(int x, int y, int z) {
        if (!this.isInside(x, y, z)) {
            return true;
        }
        BlockState state = this.getLastState();
        if (state != null) {
            return ShapeBlockInfo.isNonSolidBlock(state.func_177230_c());
        }
        return false;
    }

    default public boolean isCustom() {
        return false;
    }

    default public IFormula correctFormula(boolean solid) {
        if (solid) {
            return this;
        }
        return new IFormula(){

            @Override
            public void setup(World world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundNBT card) {
                IFormula.this.setup(world, thisCoord, dimension, offset, card);
            }

            @Override
            public void getCheckSumClient(CompoundNBT cardTag, Check32 crc) {
                IFormula.this.getCheckSumClient(cardTag, crc);
            }

            @Override
            public BlockState getLastState() {
                return IFormula.this.getLastState();
            }

            @Override
            public boolean isInside(int x, int y, int z) {
                return IFormula.this.isBorder(x, y, z);
            }

            @Override
            public boolean isBorder(int x, int y, int z) {
                return IFormula.this.isBorder(x, y, z);
            }
        };
    }
}

