/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Counter;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbuilder.modules.builder.BlockInformation;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.builder.network.PacketChamberInfoReady;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class BuilderTools {
    public static void returnChamberInfo(PlayerEntity player) {
        ItemStack cardItem = player.func_184586_b(Hand.MAIN_HAND);
        if (cardItem.func_190926_b() || cardItem.func_77978_p() == null) {
            return;
        }
        int channel = cardItem.func_77978_p().func_74762_e("channel");
        if (channel == -1) {
            return;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.get(player.func_130014_f_());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return;
        }
        ServerWorld world = LevelTools.getLevel((World)player.func_130014_f_(), chamberChannel.getDimension());
        if (world == null) {
            return;
        }
        Counter blocks = new Counter();
        Counter costs = new Counter();
        HashMap<BlockState, ItemStack> stacks = new HashMap<BlockState, ItemStack>();
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        BuilderTools.findBlocks(player, (World)world, (Counter<BlockState>)blocks, (Counter<BlockState>)costs, stacks, minCorner, maxCorner);
        Counter entitiesWithCount = new Counter();
        Counter entitiesWithCost = new Counter();
        HashMap<String, Entity> firstEntity = new HashMap<String, Entity>();
        BuilderTools.findEntities((World)world, minCorner, maxCorner, (Counter<String>)entitiesWithCount, (Counter<String>)entitiesWithCost, firstEntity);
        RFToolsBuilderMessages.INSTANCE.sendTo((Object)new PacketChamberInfoReady((Map<BlockState, Integer>)blocks, (Map<BlockState, Integer>)costs, stacks, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost, firstEntity), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void findEntities(World world, BlockPos minCorner, BlockPos maxCorner, Counter<String> entitiesWithCount, Counter<String> entitiesWithCost, Map<String, Entity> firstEntity) {
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)minCorner.func_177958_n(), (double)minCorner.func_177956_o(), (double)minCorner.func_177952_p(), (double)(maxCorner.func_177958_n() + 1), (double)(maxCorner.func_177956_o() + 1), (double)(maxCorner.func_177952_p() + 1)));
        for (Entity entity : entities) {
            ItemEntity entityItem;
            String canonicalName = entity.getClass().getCanonicalName();
            if (entity instanceof ItemEntity && !(entityItem = (ItemEntity)entity).func_92059_d().func_190926_b()) {
                String displayName = entityItem.func_92059_d().func_200301_q().getString();
                canonicalName = canonicalName + " (" + displayName + ")";
            }
            entitiesWithCount.increment((Object)canonicalName);
            if (!firstEntity.containsKey(canonicalName)) {
                firstEntity.put(canonicalName, entity);
            }
            if (entity instanceof PlayerEntity) {
                entitiesWithCost.increment((Object)canonicalName, ((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue());
                continue;
            }
            entitiesWithCost.increment((Object)canonicalName, ((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue());
        }
    }

    private static void findBlocks(PlayerEntity harvester, World world, Counter<BlockState> blocks, Counter<BlockState> costs, Map<BlockState, ItemStack> stacks, BlockPos minCorner, BlockPos maxCorner) {
        for (int x = minCorner.func_177958_n(); x <= maxCorner.func_177958_n(); ++x) {
            for (int y = minCorner.func_177956_o(); y <= maxCorner.func_177956_o(); ++y) {
                for (int z = minCorner.func_177952_p(); z <= maxCorner.func_177952_p(); ++z) {
                    TileEntity te;
                    BlockInformation info;
                    ItemStack item;
                    Block block;
                    BlockPos p = new BlockPos(x, y, z);
                    BlockState state = world.func_180495_p(p);
                    if (BuilderTileEntity.isEmpty(state, block = state.func_177230_c())) continue;
                    blocks.increment((Object)state);
                    if (!stacks.containsKey(state) && !(item = block.func_185473_a((IBlockReader)world, p, state)).func_190926_b()) {
                        stacks.put(state, item);
                    }
                    if ((info = BuilderTileEntity.getBlockInformation(harvester, world, p, block, te = world.func_175625_s(p))).getBlockLevel() == SupportBlock.SupportStatus.STATUS_ERROR) {
                        costs.put((Object)state, (Object)-1);
                        continue;
                    }
                    costs.increment((Object)state, (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * info.getCostFactor()));
                }
            }
        }
    }
}

