/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.rectangular;

import it.zerono.mods.zerocore.lib.multiblock.rectangular.AbstractRectangularMultiblockController;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;

public enum PartPosition implements IStringSerializable
{
    Unknown,
    FrameCorner,
    FrameEastWest,
    FrameSouthNorth,
    FrameUpDown;


    public static <Controller extends AbstractRectangularMultiblockController<Controller>> PartPosition positionIn(Controller controller, BlockPos blockPosition) {
        return controller.mapBoundingBoxCoordinates((min, max) -> PartPosition.positionIn(blockPosition, min, max), (PartPosition)Unknown);
    }

    public boolean isFrame() {
        return this != Unknown;
    }

    public boolean isCorner() {
        return this == FrameCorner;
    }

    public static EnumProperty<PartPosition> createProperty(String name) {
        return EnumProperty.func_177709_a((String)name, PartPosition.class);
    }

    public String func_176610_l() {
        return this.toString();
    }

    private static PartPosition positionIn(BlockPos blockPosition, BlockPos minimumCoord, BlockPos maximumCoord) {
        boolean downFacing = blockPosition.func_177956_o() == minimumCoord.func_177956_o();
        boolean upFacing = blockPosition.func_177956_o() == maximumCoord.func_177956_o();
        boolean northFacing = blockPosition.func_177952_p() == minimumCoord.func_177952_p();
        boolean southFacing = blockPosition.func_177952_p() == maximumCoord.func_177952_p();
        boolean westFacing = blockPosition.func_177958_n() == minimumCoord.func_177958_n();
        boolean eastFacing = blockPosition.func_177958_n() == maximumCoord.func_177958_n();
        int facesMatching = 0;
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        PartPosition position = 3 == facesMatching ? FrameCorner : (2 == facesMatching ? (!eastFacing && !westFacing ? FrameEastWest : (!southFacing && !northFacing ? FrameSouthNorth : FrameUpDown)) : Unknown);
        return position;
    }
}

