/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.filter;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.filter.Filter;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterManager;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterComponentFactory;
import it.zerono.mods.zerocore.lib.item.inventory.filter.ItemStackFilterCondition;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterInventory
extends Filter
implements IItemHandlerModifiable {
    private int _size;
    private static final ResourceLocation COMPONENT_ID = ZeroCore.newID("inventory.filter.FilterInventory");

    public FilterInventory(int size) {
        this._size = size;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getComponentId() {
        return COMPONENT_ID;
    }

    public int getSlots() {
        return this._size;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getFilterStack(slot).map(ItemStackFilterCondition::getFilterStack).orElse(ItemHelper.stackEmpty());
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemHelper.stackEmpty();
        }
        this.validateSlotIndex(slot);
        Optional<ItemStackFilterCondition> itemStackFilter = this.getFilterStack(slot);
        if (!itemStackFilter.isPresent()) {
            if (!simulate) {
                this.addFilterStack(slot, stack);
            }
            return ItemHelper.stackEmpty();
        }
        ItemStack existing = itemStackFilter.get().getFilterStack();
        if (null == existing) {
            if (!simulate) {
                itemStackFilter.get().setFilterStack(stack);
            }
            return ItemHelper.stackEmpty();
        }
        int limit = stack.func_77976_d();
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
            return stack;
        }
        if ((limit -= existing.func_190916_E()) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
        }
        return reachedLimit ? ItemHelper.stackFrom(stack, stack.func_190916_E() - limit) : ItemHelper.stackEmpty();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemHelper.stackEmpty();
        }
        this.validateSlotIndex(slot);
        Optional<ItemStackFilterCondition> itemStackFilter = this.getFilterStack(slot);
        if (!itemStackFilter.isPresent()) {
            return ItemHelper.stackEmpty();
        }
        ItemStack existing = itemStackFilter.get().getFilterStack();
        if (existing == null) {
            return ItemHelper.stackEmpty();
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.removeFilterStack(slot);
            }
            return existing;
        }
        if (!simulate) {
            itemStackFilter.get().setFilterStack(existing, existing.func_190916_E() - toExtract);
        }
        return ItemHelper.stackFrom(existing, toExtract);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        CodeHelper.optionalIfPresentOrElse(this.getFilterStack(slot), filter -> {
            ItemStack existing = filter.getFilterStack();
            if (null == existing || !ItemStack.func_77989_b((ItemStack)existing, (ItemStack)stack)) {
                filter.setFilterStack(stack);
            }
        }, () -> this.addFilterStack(slot, stack));
    }

    public int getSlotLimit(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        return stack.func_190926_b() ? 0 : stack.func_77976_d();
    }

    private boolean isSlotIndexValid(int slot) {
        return slot >= 0 && slot < this._size;
    }

    private void validateSlotIndex(int slot) {
        if (!this.isSlotIndexValid(slot)) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this._size + ")");
        }
    }

    private Optional<ItemStackFilterCondition> getFilterStack(int slot) {
        if (!this.isSlotIndexValid(slot)) {
            return Optional.empty();
        }
        return this.getCondition(String.valueOf(slot)).filter(c -> c instanceof ItemStackFilterCondition).map(c -> (ItemStackFilterCondition)c);
    }

    private void addFilterStack(int slot, ItemStack stack) {
        this.addCondition(String.valueOf(slot), new ItemStackFilterCondition(stack));
    }

    private void removeFilterStack(int slot) {
        this.removeCondition(String.valueOf(slot));
    }

    static {
        FilterManager<FilterInventory> fm = FilterManager.getInstance();
        fm.registerFactory(COMPONENT_ID, new IFilterComponentFactory<FilterInventory>(){

            @Override
            public Optional<FilterInventory> createComponent(@Nonnull ResourceLocation componentId) {
                return Optional.of(new FilterInventory(1));
            }

            @Override
            public Optional<FilterInventory> createComponent(@Nonnull ResourceLocation componentId, CompoundNBT nbt) {
                return Optional.empty();
            }
        });
    }
}

