/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.debug;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.client.debug.VoxelShapeHighlighter;
import it.zerono.mods.zerocore.lib.data.Flags;
import java.util.Collections;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

public class DebugHelper {
    private static Flags<DebugFlags> s_flags;
    private static Map<World, Map<BlockPos, VoxelShapeType>> s_blockToHighlight;

    @OnlyIn(value=Dist.CLIENT)
    public static void initVoxelShapeHighlighter() {
        if (!DebugHelper.isVoxelShapeHighlighterEnabled()) {
            ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(VoxelShapeHighlighter.class);
            DebugHelper.setFlag(DebugFlags.HighlighterInitialized);
        }
    }

    public static boolean isVoxelShapeHighlighterEnabled() {
        return DebugHelper.isFlagSet(DebugFlags.HighlighterInitialized);
    }

    public static void addVoxelShapeHighlight(World world, BlockPos position, VoxelShapeType type) {
        if (!DebugHelper.isVoxelShapeHighlighterEnabled()) {
            throw new IllegalStateException("ZeroCore Voxel shape highlighting debug facility must be initialized before using it");
        }
        if (null == s_blockToHighlight) {
            s_blockToHighlight = Maps.newHashMap();
        }
        s_blockToHighlight.computeIfAbsent(world, k -> Maps.newHashMap()).put(position, type);
    }

    public static void removeVoxelShapeHighlight(World world, BlockPos position) {
        if (null != s_blockToHighlight) {
            s_blockToHighlight.getOrDefault(world, Collections.emptyMap()).remove(position);
        }
    }

    public static VoxelShapeType getBlockVoxelShapeHighlight(World world, BlockPos position) {
        if (!DebugHelper.isVoxelShapeHighlighterEnabled()) {
            throw new IllegalStateException("ZeroCore Voxel shape highlighting debug facility must be initialized before using it");
        }
        if (null == s_blockToHighlight) {
            return VoxelShapeType.None;
        }
        return s_blockToHighlight.getOrDefault(world, Collections.emptyMap()).getOrDefault(position, VoxelShapeType.None);
    }

    public static void ungrabMouse() {
        ZeroCore.getProxy().debugUngrabMouse();
    }

    private static boolean isFlagSet(DebugFlags flag) {
        return null != s_flags && s_flags.contains(flag);
    }

    private static void setFlag(DebugFlags flag) {
        if (null == s_flags) {
            s_flags = new Flags((Enum)flag, (Enum[])new DebugFlags[0]);
        } else {
            s_flags.add(flag);
        }
    }

    private static enum DebugFlags {
        HighlighterInitialized;

    }

    public static enum VoxelShapeType {
        General,
        Render,
        Collision,
        RayTrace,
        None;

    }
}

