/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.util.NonNullFunction;

public class CuboidBoundingBox
implements Iterable<BlockPos> {
    public static final CuboidBoundingBox EMPTY = new CuboidBoundingBox(){

        @Override
        public AxisAlignedBB getAABB() {
            return CodeHelper.EMPTY_BOUNDING_BOX;
        }

        @Override
        public CuboidBoundingBox add(BlockPos position) {
            return new CuboidBoundingBox((Vector3i)position, (Vector3i)position);
        }

        @Override
        public CuboidBoundingBox remove(BlockPos position) {
            return EMPTY;
        }

        @Override
        public CuboidBoundingBox combine(CuboidBoundingBox other) {
            return new CuboidBoundingBox((Vector3i)other._min, (Vector3i)other._max);
        }

        @Override
        public boolean equals(Object other) {
            return other == EMPTY;
        }
    };
    private final BlockPos.Mutable _min;
    private final BlockPos.Mutable _max;

    public CuboidBoundingBox() {
        this((Vector3i)CodeHelper.MAX_BLOCKPOS, (Vector3i)CodeHelper.MIN_BLOCKPOS);
    }

    public CuboidBoundingBox(Vector3i min, Vector3i max) {
        this._min = new BlockPos.Mutable(min.func_177958_n(), min.func_177956_o(), min.func_177952_p());
        this._max = new BlockPos.Mutable(max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public CuboidBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this._min = new BlockPos.Mutable(minX, minY, minZ);
        this._max = new BlockPos.Mutable(maxX, maxY, maxZ);
    }

    public BlockPos getMin() {
        return this._min.func_185334_h();
    }

    public BlockPos getMax() {
        return this._max.func_185334_h();
    }

    public int getMinX() {
        return this._min.func_177958_n();
    }

    public int getMinY() {
        return this._min.func_177956_o();
    }

    public int getMinZ() {
        return this._min.func_177952_p();
    }

    public int getMaxX() {
        return this._max.func_177958_n();
    }

    public int getMaxY() {
        return this._max.func_177956_o();
    }

    public int getMaxZ() {
        return this._max.func_177952_p();
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB((BlockPos)this._min, (BlockPos)this._max);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public CuboidBoundingBox add(BlockPos position) {
        CuboidBoundingBox.adjustPosition(this._min, position, Math::min);
        CuboidBoundingBox.adjustPosition(this._max, position, Math::max);
        return this;
    }

    public CuboidBoundingBox remove(BlockPos position) {
        return EMPTY;
    }

    public CuboidBoundingBox combine(CuboidBoundingBox other) {
        CuboidBoundingBox.adjustPosition(this._min, (BlockPos)other._min, Math::min);
        CuboidBoundingBox.adjustPosition(this._max, (BlockPos)other._max, Math::max);
        return this;
    }

    public boolean contains(Vector3i vec) {
        return this.contains(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this._min.func_177958_n() && x <= this._max.func_177958_n() && y >= this._min.func_177956_o() && y <= this._max.func_177956_o() && z >= this._min.func_177952_p() && z <= this._max.func_177952_p();
    }

    public int getLengthX() {
        return this._max.func_177958_n() - this._min.func_177958_n() + 1;
    }

    public int getLengthY() {
        return this._max.func_177956_o() - this._min.func_177956_o() + 1;
    }

    public int getLengthZ() {
        return this._max.func_177952_p() - this._min.func_177952_p() + 1;
    }

    public int getLength(Direction.Axis axis) {
        switch (axis) {
            default: {
                return this.getLengthX();
            }
            case Y: {
                return this.getLengthY();
            }
            case Z: 
        }
        return this.getLengthZ();
    }

    public int getVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume((BlockPos)this._min, (BlockPos)this._max);
    }

    public int getInternalVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume(this._min.func_177982_a(1, 1, 1), this._max.func_177982_a(-1, -1, -1));
    }

    public BlockPos getCenter() {
        return this._min.func_177982_a(this.getLengthX() / 2, this.getLengthY() / 2, this.getLengthZ() / 2);
    }

    public int commonVertices(Vector3i position) {
        return CodeHelper.commonVertices(position, (Vector3i)this._min) + CodeHelper.commonVertices(position, (Vector3i)this._max);
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper) {
        return mapper.apply(this.getMin(), this.getMax());
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper, NonNullFunction<BlockPos, BlockPos> minRemapper, NonNullFunction<BlockPos, BlockPos> maxRemapper) {
        return mapper.apply((BlockPos)minRemapper.apply((Object)this.getMin()), (BlockPos)maxRemapper.apply((Object)this.getMax()));
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer) {
        consumer.accept(this.getMin(), this.getMax());
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer, NonNullFunction<BlockPos, BlockPos> minRemapper, NonNullFunction<BlockPos, BlockPos> maxRemapper) {
        consumer.accept((BlockPos)minRemapper.apply((Object)this.getMin()), (BlockPos)maxRemapper.apply((Object)this.getMax()));
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new AbstractIterator<BlockPos>(){
            final BlockPos.Mutable _cursor = new BlockPos.Mutable();
            final int _minX = CuboidBoundingBox.access$000(CuboidBoundingBox.this).func_177958_n();
            final int _minY = CuboidBoundingBox.access$000(CuboidBoundingBox.this).func_177956_o();
            final int _minZ = CuboidBoundingBox.access$000(CuboidBoundingBox.this).func_177952_p();
            final int _maxX = CuboidBoundingBox.access$100(CuboidBoundingBox.this).func_177958_n();
            final int _maxY = CuboidBoundingBox.access$100(CuboidBoundingBox.this).func_177956_o();
            final int _maxZ = CuboidBoundingBox.access$100(CuboidBoundingBox.this).func_177952_p();
            int _currentX = this._minX - 1;
            int _currentY = this._minY;
            int _currentZ = this._minZ;

            protected BlockPos computeNext() {
                ++this._currentX;
                if (this._currentX > this._maxX) {
                    this._currentX = this._minX;
                    ++this._currentZ;
                    if (this._currentZ > this._maxZ) {
                        this._currentZ = this._minZ;
                        ++this._currentY;
                        if (this._currentY > this._maxY) {
                            return (BlockPos)this.endOfData();
                        }
                    }
                }
                return this._cursor.func_181079_c(this._currentX, this._currentY, this._currentZ);
            }
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CuboidBoundingBox)) {
            return false;
        }
        CuboidBoundingBox otherBB = (CuboidBoundingBox)other;
        return 0 == this._min.compareTo((Vector3i)otherBB._min) && 0 == this._max.compareTo((Vector3i)otherBB._max);
    }

    public int hashCode() {
        return Objects.hash(this._min, this._max);
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : String.format("%s -> %s", CodeHelper.toString((Vector3i)this._min), CodeHelper.toString((Vector3i)this._max));
    }

    private static boolean adjustPosition(BlockPos.Mutable currentPosition, BlockPos newPosition, IntComparator minMax) {
        int curX = currentPosition.func_177958_n();
        int curY = currentPosition.func_177956_o();
        int curZ = currentPosition.func_177952_p();
        int newX = minMax.compare(currentPosition.func_177958_n(), newPosition.func_177958_n());
        int newY = minMax.compare(currentPosition.func_177956_o(), newPosition.func_177956_o());
        int newZ = minMax.compare(currentPosition.func_177952_p(), newPosition.func_177952_p());
        if (newX != curX || newY != curY || newZ != curZ) {
            currentPosition.func_181079_c(newX, newY, newZ);
            return true;
        }
        return false;
    }
}

