/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.util;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class CompactStorageUtilMethods {
    public static LazyOptional<ItemStackHandler> validateHandlerSize(LazyOptional<ItemStackHandler> handler, int width, int height) {
        return LazyOptional.of(() -> CompactStorageUtilMethods.validateHandlerSize((ItemStackHandler)handler.orElseThrow(NullPointerException::new), width, height));
    }

    public static ItemStackHandler validateHandlerSize(ItemStackHandler handler, int width, int height) {
        if (handler.getSlots() != width * height) {
            ItemStackHandler newInventory = new ItemStackHandler(width * height);
            for (int x = 0; x < handler.getSlots(); ++x) {
                newInventory.setStackInSlot(x, handler.getStackInSlot(x));
            }
            return newInventory;
        }
        return handler;
    }

    public static void addInformationForUpgradableBlocks(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int width = 9;
        int height = 3;
        boolean upgraded = false;
        boolean retaining = false;
        if (stack.func_77942_o() && stack.func_179543_a("BlockEntityTag") != null) {
            upgraded = true;
            CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
            width = tag.func_74764_b("width") ? tag.func_74762_e("width") : 9;
            height = tag.func_74764_b("height") ? tag.func_74762_e("height") : 3;
            upgraded = width != 9 && height != 3;
            retaining = tag.func_74764_b("Inventory");
        }
        StringTextComponent widthComponent = new StringTextComponent("Width: ");
        widthComponent.func_230529_a_((ITextComponent)new StringTextComponent(width + "").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        StringTextComponent heightComponent = new StringTextComponent("Height: ");
        heightComponent.func_230529_a_((ITextComponent)new StringTextComponent(height + "").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        tooltip.add((ITextComponent)widthComponent);
        tooltip.add((ITextComponent)heightComponent);
        if (retaining) {
            tooltip.add((ITextComponent)new StringTextComponent("Retaining").func_240699_a_(TextFormatting.AQUA));
        }
        if (upgraded) {
            tooltip.add((ITextComponent)new StringTextComponent("Upgraded").func_240699_a_(TextFormatting.RED));
        }
    }

    public static enum UpgradeStatus {
        SUCCESS,
        MAX_WIDTH,
        MAX_HEIGHT,
        IN_USE,
        ERROR;

    }
}

