/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.item;

import java.util.List;
import java.util.UUID;
import me.tobystrong.compactstorage.CompactStorage;
import me.tobystrong.compactstorage.container.BackpackContainer;
import me.tobystrong.compactstorage.util.CompactStorageUtilMethods;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackItem
extends Item {
    public BackpackItem() {
        super(new Item.Properties().func_200916_a(CompactStorage.compactStorageItemGroup).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_184586_b(handIn).func_77942_o()) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a("width", 9);
                tag.func_74768_a("height", 3);
                playerIn.func_184586_b(handIn).func_77982_d(tag);
            }
            if (handIn == Hand.MAIN_HAND) {
                ItemStack mainHand = playerIn.func_184614_ca();
                ItemStack offHand = playerIn.func_184586_b(Hand.OFF_HAND);
                BlockPos pos = new BlockPos(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_());
                pos = pos.func_177963_a(0.0, 1.0, 0.0);
                ServerWorld serverWorld = (ServerWorld)worldIn;
                if (offHand.func_77973_b() == CompactStorage.upgrade_row) {
                    int width = mainHand.func_77978_p().func_74762_e("width");
                    if (width < 24) {
                        mainHand.func_77978_p().func_74768_a("width", width + 1);
                        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5, 0.25, 0.0, 0.25, 0.0);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        offHand.func_190920_e(offHand.func_190916_E() - 1);
                        return ActionResult.func_226250_c_((Object)mainHand);
                    }
                    serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197609_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5, 0.25, 0.0, 0.25, 0.0);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_194227_ie, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("message.compactstorage.upgrade.max_width_backpack"), UUID.randomUUID());
                    return ActionResult.func_226251_d_((Object)mainHand);
                }
                if (offHand.func_77973_b() == CompactStorage.upgrade_column) {
                    int height = mainHand.func_77978_p().func_74762_e("height");
                    if (height < 12) {
                        mainHand.func_77978_p().func_74768_a("height", height + 1);
                        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5, 0.25, 0.0, 0.25, 0.0);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!playerIn.func_184812_l_()) {
                            offHand.func_190920_e(offHand.func_190916_E() - 1);
                        }
                        return ActionResult.func_226250_c_((Object)mainHand);
                    }
                    serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197609_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5, 0.25, 0.0, 0.25, 0.0);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_194227_ie, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("message.compactstorage.upgrade.max_height_backpack"), UUID.randomUUID());
                    return ActionResult.func_226251_d_((Object)mainHand);
                }
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerIn;
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)new BackpackItemContainerProvider(handIn, playerIn.func_184586_b(handIn)), buf -> buf.writeInt(handIn == Hand.MAIN_HAND ? 0 : 1));
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int width = 9;
        int height = 3;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("width")) {
            width = stack.func_77978_p().func_74762_e("width");
            height = stack.func_77978_p().func_74762_e("height");
        }
        StringTextComponent widthComponent = new StringTextComponent("Width: ");
        widthComponent.func_230529_a_((ITextComponent)new StringTextComponent(width + "").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        StringTextComponent heightComponent = new StringTextComponent("Height: ");
        heightComponent.func_230529_a_((ITextComponent)new StringTextComponent(height + "").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        tooltip.add((ITextComponent)widthComponent);
        tooltip.add((ITextComponent)heightComponent);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public class BackpackItemContainerProvider
    implements INamedContainerProvider {
        private int inventoryWidth;
        private int inventoryHeight;
        private ItemStackHandler inventory;
        private Hand hand;

        public BackpackItemContainerProvider(Hand hand, ItemStack backpack) {
            CompoundNBT tag;
            int inventoryWidth = 9;
            int inventoryHeight = 3;
            if (backpack.func_77978_p() == null) {
                backpack.func_77982_d(new CompoundNBT());
            }
            if (!(tag = backpack.func_77978_p()).func_74764_b("width")) {
                tag.func_74768_a("width", inventoryWidth);
                tag.func_74768_a("height", inventoryHeight);
            } else {
                inventoryWidth = tag.func_74762_e("width");
                inventoryHeight = tag.func_74762_e("height");
            }
            ItemStackHandler inventoryHandler = new ItemStackHandler(inventoryWidth * inventoryHeight);
            if (tag.func_74764_b("Inventory")) {
                inventoryHandler.deserializeNBT(tag.func_74775_l("Inventory"));
                inventoryHandler = CompactStorageUtilMethods.validateHandlerSize(inventoryHandler, inventoryWidth, inventoryHeight);
            }
            this.inventoryWidth = inventoryWidth;
            this.inventoryHeight = inventoryHeight;
            this.inventory = inventoryHandler;
            this.hand = hand;
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.compactstorage.backpack");
        }

        public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new BackpackContainer(windowID, playerInventory, this.inventoryWidth, this.inventoryHeight, this.inventory, this.hand);
        }
    }
}

