/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import me.tobystrong.compactstorage.block.CompactChestBlock;
import me.tobystrong.compactstorage.block.tile.CompactChestTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class CompactChestTileEntityRenderer
extends TileEntityRenderer<CompactChestTileEntity> {
    private final ModelRenderer singleLid;
    private final ModelRenderer singleBottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer singleLatch;
    public static Map<String, ResourceLocation> compactChestTextures = new HashMap<String, ResourceLocation>();

    public CompactChestTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.singleBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.singleLid = new ModelRenderer(64, 64, 0, 0);
        this.singleLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.singleLid.field_78797_d = 9.0f;
        this.singleLid.field_78798_e = 1.0f;
        this.singleLatch = new ModelRenderer(64, 64, 0, 0);
        this.singleLatch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.singleLatch.field_78797_d = 8.0f;
    }

    public void render(CompactChestTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        BlockState blockstate = tileEntityIn.func_195044_w();
        Block block = blockstate.func_177230_c();
        matrixStackIn.func_227860_a_();
        float f = ((Direction)blockstate.func_177229_b(CompactChestBlock.PROPERTY_FACING)).func_185119_l();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
        float lidAngle = tileEntityIn.func_195480_a(partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)compactChestTextures.get(block.getRegistryName().func_110623_a())));
        this.singleLatch.field_78795_f = this.singleLid.field_78795_f = -(lidAngle * 1.5707964f);
        this.singleLid.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.singleLatch.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.singleBottom.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
    }

    static {
        for (int i = 0; i < DyeColor.values().length; ++i) {
            String chest = "compact_chest_" + DyeColor.values()[i].name().toLowerCase();
            compactChestTextures.put(chest, new ResourceLocation("compactstorage", "textures/entities/" + chest + ".png"));
        }
    }
}

