/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.block.tile;

import me.tobystrong.compactstorage.CompactStorage;
import me.tobystrong.compactstorage.block.tile.BaseTileEntity;
import me.tobystrong.compactstorage.container.CompactChestContainer;
import me.tobystrong.compactstorage.util.CompactStorageUtilMethods;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class CompactChestTileEntity
extends BaseTileEntity
implements IChestLid {
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;

    public CompactChestTileEntity() {
        super(CompactStorage.COMPACT_CHEST_TILE_TYPE);
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.compactstorage.compact_chest");
    }

    @Override
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.inventory = CompactStorageUtilMethods.validateHandlerSize((LazyOptional<ItemStackHandler>)this.inventory, this.width, this.height);
        return new CompactChestContainer(windowId, playerInventory, this.width, this.height, this, (IItemHandler)this.inventory.orElseThrow(NullPointerException::new));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.prevLidAngle = this.lidAngle;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float f1 = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f2 = 0.5f;
            if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }
}

