/*
 * Decompiled with CFR 0.152.
 */
package me.tobystrong.compactstorage.block.tile;

import java.util.List;
import me.tobystrong.compactstorage.CompactStorage;
import me.tobystrong.compactstorage.container.CompactStorageBaseContainer;
import me.tobystrong.compactstorage.util.CompactStorageUtilMethods;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class BaseTileEntity
extends TileEntity
implements INamedContainerProvider,
ICapabilitySerializable<CompoundNBT>,
ITickableTileEntity {
    public LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(27));
    public int width = 9;
    public int height = 3;
    protected int playersUsing = 0;

    public BaseTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean canPlayerAccess(PlayerEntity entity) {
        return entity.func_226277_ct_() > (double)(this.field_174879_c.func_177958_n() - 5) && entity.func_226278_cu_() > (double)(this.field_174879_c.func_177956_o() - 5) && entity.func_226281_cx_() > (double)(this.field_174879_c.func_177952_p() - 5) && entity.func_226277_ct_() < (double)(this.field_174879_c.func_177958_n() + 5) && entity.func_226278_cu_() < (double)(this.field_174879_c.func_177956_o() + 5) && entity.func_226281_cx_() < (double)(this.field_174879_c.func_177952_p() + 5);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.inventory.ifPresent(inv -> compound.func_218657_a("Inventory", (INBT)inv.serializeNBT()));
        compound.func_74768_a("width", this.width);
        compound.func_74768_a("height", this.height);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.ifPresent(inv -> inv.deserializeNBT(nbt.func_74775_l("Inventory")));
        this.width = nbt.func_74764_b("width") ? nbt.func_74762_e("width") : 9;
        int n = this.height = nbt.func_74764_b("height") ? nbt.func_74762_e("height") : 3;
        if (!this.inventory.isPresent()) {
            this.inventory = LazyOptional.of(() -> new ItemStackHandler(27));
        }
        this.inventory = CompactStorageUtilMethods.validateHandlerSize(this.inventory, this.width, this.height);
    }

    public CompactStorageUtilMethods.UpgradeStatus handleUpgradeItem(ItemStack upgrade) {
        if (this.playersUsing == 0) {
            if (upgrade.func_77973_b() == CompactStorage.upgrade_row) {
                if (this.width == 24) {
                    return CompactStorageUtilMethods.UpgradeStatus.MAX_WIDTH;
                }
                ++this.width;
                return CompactStorageUtilMethods.UpgradeStatus.SUCCESS;
            }
            if (upgrade.func_77973_b() == CompactStorage.upgrade_column) {
                if (this.height == 12) {
                    return CompactStorageUtilMethods.UpgradeStatus.MAX_HEIGHT;
                }
                ++this.height;
                return CompactStorageUtilMethods.UpgradeStatus.SUCCESS;
            }
        } else {
            return CompactStorageUtilMethods.UpgradeStatus.IN_USE;
        }
        return CompactStorageUtilMethods.UpgradeStatus.ERROR;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), tag);
    }

    public void func_73660_a() {
        this.playersUsing = 0;
        float d = 5.0f;
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c.func_177963_a((double)(-d), (double)(-d), (double)(-d)), this.field_174879_c.func_177963_a((double)d, (double)d, (double)d)));
        for (PlayerEntity p : players) {
            if (!(p.field_71070_bA instanceof CompactStorageBaseContainer)) continue;
            CompactStorageBaseContainer container = (CompactStorageBaseContainer)p.field_71070_bA;
            if (container.chestInventory != this.inventory.orElseThrow(NullPointerException::new)) continue;
            ++this.playersUsing;
        }
    }

    public abstract ITextComponent func_145748_c_();

    public abstract Container createMenu(int var1, PlayerInventory var2, PlayerEntity var3);
}

